/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.io.NbMarshalledObject;

public abstract class ServiceType
implements Serializable,
HelpCtx.Provider {
    private static final long serialVersionUID = -7573598174423654252L;
    public static final String PROP_NAME = "name";
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.ServiceType");
    private String name;
    private transient PropertyChangeSupport supp;

    protected String displayName() {
        try {
            return Introspector.getBeanInfo(this.getClass()).getBeanDescriptor().getDisplayName();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, exception);
            return this.getClass().getName();
        }
    }

    public final ServiceType createClone() {
        Exception exception;
        block6: {
            if (this instanceof Cloneable) {
                try {
                    return (ServiceType)this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    exception = cloneNotSupportedException;
                    break block6;
                }
            }
            try {
                NbMarshalledObject nbMarshalledObject = new NbMarshalledObject(this);
                return (ServiceType)nbMarshalledObject.get();
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception = classNotFoundException;
            }
        }
        IllegalStateException illegalStateException = new IllegalStateException();
        ErrorManager errorManager = ErrorManager.getDefault();
        errorManager.copyAnnotation(illegalStateException, exception);
        errorManager.annotate((Throwable)illegalStateException, "Cannot createClone for " + this);
        throw illegalStateException;
    }

    protected Object clone() throws CloneNotSupportedException {
        ServiceType serviceType = (ServiceType)super.clone();
        serviceType.supp = null;
        serviceType.name = null;
        return serviceType;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (this.supp != null) {
            this.supp.firePropertyChange(PROP_NAME, string2, string);
        }
    }

    public String getName() {
        return this.name == null ? this.displayName() : this.name;
    }

    @Override
    public abstract HelpCtx getHelpCtx();

    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.supp == null) {
            this.supp = new PropertyChangeSupport(this);
        }
        this.supp.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.supp != null) {
            this.supp.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (this.supp != null) {
            this.supp.firePropertyChange(string, object, object2);
        }
    }

    public static final class Handle
    implements Serializable {
        static final long serialVersionUID = 7233109534462148872L;
        private String name;
        private String className;
        private transient ServiceType serviceType;

        public Handle(ServiceType serviceType) {
            this.name = serviceType.getName();
            this.className = serviceType.getClass().getName();
            this.serviceType = serviceType;
        }

        public ServiceType getServiceType() {
            if (this.serviceType == null) {
                Class<Object> clazz;
                Class<Object> clazz2;
                try {
                    clazz2 = Class.forName(this.className, true, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
                    clazz = clazz2;
                    while (clazz.getSuperclass() != ServiceType.class) {
                        clazz = clazz.getSuperclass();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    err.log(1, "Service not found: " + classNotFoundException.toString());
                    clazz2 = ServiceType.class;
                    clazz = ServiceType.class;
                }
                Registry registry = (Registry)Lookup.getDefault().lookup(Registry.class);
                Enumeration enumeration = registry.services(clazz2);
                ServiceType serviceType = registry.find(clazz2);
                while (enumeration.hasMoreElements()) {
                    ServiceType serviceType2 = (ServiceType)enumeration.nextElement();
                    if (!clazz.isInstance(serviceType2)) continue;
                    String string = serviceType2.getName();
                    if (string != null && string.equals(this.name)) {
                        return serviceType2;
                    }
                    if (serviceType != null && (serviceType.getClass() == clazz2 || serviceType2.getClass() != clazz2)) continue;
                    serviceType = serviceType2;
                }
                if (clazz == ServiceType.class) {
                    return null;
                }
                return serviceType;
            }
            return this.serviceType;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.name = (String)objectInputStream.readObject();
            String string = (String)objectInputStream.readObject();
            this.className = string == null ? null : Utilities.translate(string);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.name);
            objectOutputStream.writeObject(this.className);
        }

        public String toString() {
            return "Handle[" + this.className + ":" + this.name + "]";
        }
    }

    public static abstract class Registry
    implements Serializable {
        static final long serialVersionUID = 8721000770371416481L;

        public abstract Enumeration services();

        public Enumeration services(final Class clazz) {
            class IsInstance
            implements Enumerations.Processor {
                IsInstance() {
                }

                @Override
                public Object process(Object object, Collection collection) {
                    return clazz.isInstance(object) ? object : null;
                }
            }
            return Enumerations.filter(this.services(), new IsInstance());
        }

        public abstract List getServiceTypes();

        public abstract void setServiceTypes(List var1);

        public ServiceType find(Class clazz) {
            Enumeration enumeration = this.services();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e.getClass() != clazz) continue;
                return (ServiceType)e;
            }
            return null;
        }

        public ServiceType find(String string) {
            Enumeration enumeration = this.services();
            while (enumeration.hasMoreElements()) {
                ServiceType serviceType = (ServiceType)enumeration.nextElement();
                if (!string.equals(serviceType.getName())) continue;
                return serviceType;
            }
            return null;
        }
    }
}

