/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.desktop.example;

import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.testmeas.desktop.example.PlotParameterPanel;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTLayoutLibrary;
import com.mathworks.widgets.desk.DTMenuBar;
import com.mathworks.widgets.desk.DTToolBar;
import com.mathworks.widgets.desk.DTWindowActivator;
import com.mathworks.widgets.desk.DTWindowRegistry;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JMenu;

public class PlotDesktop
extends Desktop {
    public static ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.toolbox.testmeas.desktop.example.resources.RES_EXAMPLE");
    private static PlotDesktop sInstance = null;
    private Callback fReopenCallback = new Callback();
    private Callback fCloseCallback = new Callback();
    private boolean fGlassPaneOn = false;

    public static synchronized PlotDesktop getInstance() {
        if (sInstance == null) {
            sInstance = new PlotDesktop();
        }
        return sInstance;
    }

    public static synchronized boolean hasInstance() {
        return sInstance != null;
    }

    private PlotDesktop() {
        super(sResources.getString("Desktop.Title"), false);
    }

    public synchronized void enableGlassPane(boolean bl) {
        if (bl) {
            GlobalCursor.setWait((Window)this.getMainFrame());
            GlobalCursor.setWait((Window)((DTFrame)((MJPanel)this.getClient(sResources.getString("PlotParametersPanel.Title"))).getTopLevelAncestor()));
            if (this.getFrameContainingGroup(sResources.getString("PlotGroup.Title")) != null) {
                GlobalCursor.setWait((Window)this.getFrameContainingGroup(sResources.getString("PlotGroup.Title")));
            }
            this.fGlassPaneOn = true;
        } else {
            if (!this.isGlassPaneOn()) {
                return;
            }
            GlobalCursor.clear((Window)this.getMainFrame());
            GlobalCursor.clear((Window)((DTFrame)((MJPanel)this.getClient(sResources.getString("PlotParametersPanel.Title"))).getTopLevelAncestor()));
            if (this.getFrameContainingGroup(sResources.getString("PlotGroup.Title")) != null) {
                GlobalCursor.clear((Window)this.getFrameContainingGroup(sResources.getString("PlotGroup.Title")));
            }
            this.fGlassPaneOn = false;
        }
    }

    public static synchronized void openDesktop() {
        if (sInstance == null || !sInstance.hasMainFrame()) {
            boolean bl;
            boolean bl2 = bl = sInstance != null;
            if (!bl) {
                sInstance = new PlotDesktop();
            }
            DTWindowRegistry.getInstance().addActivator((DTWindowActivator)sInstance);
            PlotDesktop.getInstance().initMainFrame(false, true);
            PlotDesktop.getInstance().enableGlassPane(true);
            if (bl) {
                PlotDesktop.getInstance().fReopenCallback.postCallback();
            }
        }
    }

    public void close(boolean bl) {
        if (!this.isGlassPaneOn()) {
            this.fCloseCallback.postCallback();
        }
    }

    public void closeAfterCallback() {
        super.close(true);
    }

    public void hidePlotToolbar() {
        this.getGroupContainer("Plot Panel").getParent().getComponent(0).setVisible(false);
    }

    protected DTLayoutLibrary getLayoutLibrary() {
        boolean bl = this.fLayoutLibrary == null;
        DTLayoutLibrary dTLayoutLibrary = super.getLayoutLibrary();
        if (bl) {
            dTLayoutLibrary.addFactoryLayout(sResources.getString("Desktop.InitialLayout"), PlotDesktop.class.getResource("resources/InitialLayout.xml"));
        }
        return dTLayoutLibrary;
    }

    public void setDefaultDesktop() {
        URL uRL = PlotDesktop.class.getResource("resources/InitialLayout.xml");
        if (uRL == null) {
            this.addClient((Component)((Object)PlotParameterPanel.getInstance()), sResources.getString("PlotParametersPanel.Title"));
        } else {
            try {
                InputStream inputStream = uRL.openStream();
                this.restoreLayout(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                System.out.println(sResources.getString("Desktop.InitialLayoutError"));
            }
        }
    }

    protected DTToolBar createToolBar(DTFrame dTFrame) {
        return null;
    }

    protected DTMenuBar createMenuBar(DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
        return new PlotDesktopMenuBar(this, dTFrame, dTClient, dTGroup);
    }

    public Callback getReopenCallback() {
        return this.fReopenCallback;
    }

    public Callback getCloseCallback() {
        return this.fCloseCallback;
    }

    public synchronized boolean isGlassPaneOn() {
        return this.fGlassPaneOn;
    }

    private class PlotDesktopMenuBar
    extends DTMenuBar {
        private static final long serialVersionUID = 7312652410982955182L;

        public PlotDesktopMenuBar(Desktop desktop, DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
            super(desktop, dTFrame, dTClient, dTGroup);
        }

        protected void populate() {
            if (this.fFrame.isMainFrame() || this.fDesktop.hasMainFrame()) {
                this.add((JMenu)this.fFrame.getDesktopMenu());
            }
            this.add((JMenu)this.fFrame.getWindowMenu());
        }
    }
}

