/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.propertyeditor;

import com.mathworks.html.HtmlComponent;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolbox.testmeas.propertyeditor.Property;
import com.mathworks.toolbox.testmeas.propertyeditor.UIConstants;
import com.mathworks.toolbox.testmeas.template.RepeatToken;
import com.mathworks.toolbox.testmeas.template.ReplaceToken;
import com.mathworks.toolbox.testmeas.template.StringTokenHandler;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;

public class HelpWindow {
    private static String TEMPLATE_STRING = "";
    private static final String PROP_NAME_TOKEN = "__PROP_NAME__";
    private static final String HELP_TEXT_TOKEN = "__HELP_TEXT__";
    private static final String FOR_EACH_TOKEN = "__FOR_EACH_PROP__";
    private MJDialog fDialog;
    private HtmlComponent fHtmlRenderer;
    private final String fAnchor;

    public HelpWindow(String string, String string2, Dimension dimension, Collection<Property> collection) {
        this.fAnchor = string2;
        this.fHtmlRenderer = HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.HTMLPANEL});
        this.fHtmlRenderer.setHtmlText(this.getText(collection));
        this.fDialog = new MJDialog((Frame)null, string, false);
        this.fDialog.getContentPane().setLayout(new BorderLayout());
        this.fDialog.getContentPane().add(this.fHtmlRenderer.getComponent(), "Center");
        this.fDialog.setSize(dimension);
    }

    public void show() {
        this.fDialog.setVisible(true);
        WindowUtils.centerWindowOnParent((Window)this.fDialog);
        this.fDialog.addWindowListener((WindowListener)new WindowClosingListener());
        this.fDialog.toFront();
    }

    private String getText(Collection<Property> collection) {
        ArrayList<StringTokenHandler> arrayList = new ArrayList<StringTokenHandler>();
        for (Property property : collection) {
            StringTokenHandler stringTokenHandler = new StringTokenHandler();
            stringTokenHandler.addToken(new ReplaceToken(PROP_NAME_TOKEN, TMStringUtil.splitOnUpperCase(property.getName())));
            String string = property.getHelp().toString();
            string = string.replaceAll("\n\n", "<br><br>");
            string = string.replaceAll("\\.\n", ".<br><br>");
            stringTokenHandler.addToken(new ReplaceToken(HELP_TEXT_TOKEN, string));
            arrayList.add(stringTokenHandler);
        }
        StringTokenHandler stringTokenHandler = new StringTokenHandler();
        stringTokenHandler.addToken(new RepeatToken(FOR_EACH_TOKEN, arrayList));
        return stringTokenHandler.processTokens(TEMPLATE_STRING);
    }

    static {
        TEMPLATE_STRING = UIConstants.getResourceBundle().getString("PropertyEditor.helpTemplate");
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private WindowClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            HelpWindow.this.fHtmlRenderer.dispose();
            HelpWindow.this.fDialog.removeWindowListener((WindowListener)this);
            HelpWindow.this.fDialog.dispose();
            HelpWindow.this.fDialog = null;
        }
    }
}

