/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.propertyeditor;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.toolbox.testmeas.propertyeditor.IPropertySetter;
import com.mathworks.toolbox.testmeas.propertyeditor.Property;
import com.mathworks.toolbox.testmeas.propertyeditor.Widget;
import com.mathworks.toolbox.testmeas.tmswing.TMAbstractStyleGuideJPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinnerWidget
extends Widget {
    private MJSpinner fSpinner;
    private ChangeListener fSpinnerChangeListener;
    private boolean fMousedown = false;
    private SpinnerMouseAdapter fMouseListener = new SpinnerMouseAdapter();

    public SpinnerWidget(IPropertySetter iPropertySetter, Property property) {
        super(iPropertySetter, property);
    }

    @Override
    public void addContent(TMAbstractStyleGuideJPanel tMAbstractStyleGuideJPanel) {
        Property property = this.getProperty();
        Number number = (Number)property.getValue();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(number, null, null, (Number)1);
        this.fSpinner = new MJSpinner((SpinnerModel)spinnerNumberModel);
        this.fSpinner.setName(property.getName() + "spinner");
        if (this.fSpinner.getEditor() instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)this.fSpinner.getEditor()).getTextField().setColumns(10);
        }
        MJComboBox mJComboBox = new MJComboBox();
        this.fSpinner.setPreferredSize(new Dimension(this.fSpinner.getPreferredSize().width, mJComboBox.getPreferredSize().height));
        this.fSpinnerChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!SpinnerWidget.this.fMousedown) {
                    SpinnerWidget.this.set(SpinnerWidget.this.fSpinner.getValue(), (Component)SpinnerWidget.this.fSpinner);
                }
            }
        };
        this.fSpinner.addChangeListener(this.fSpinnerChangeListener);
        SpinnerWidget.addMouseListenersToSpinner(this.fSpinner, this.fMouseListener);
        tMAbstractStyleGuideJPanel.addLine((JComponent[][])new JComponent[][]{{this.fSpinner, null}}, 0, 1);
    }

    @Override
    public void displayValue(Object object) {
        if (object == null) {
            return;
        }
        this.fSpinner.removeChangeListener(this.fSpinnerChangeListener);
        Object object2 = object;
        if (object instanceof double[]) {
            object2 = ((double[])object)[0];
        }
        this.fSpinner.setValue(object2);
        this.fSpinner.addChangeListener(this.fSpinnerChangeListener);
    }

    @Override
    public void enableWidget(boolean bl) {
        this.fSpinner.setEnabled(bl);
    }

    @Override
    public void cleanup() {
        ChangeListener[] changeListenerArray;
        for (ChangeListener changeListener : changeListenerArray = this.fSpinner.getChangeListeners()) {
            this.fSpinner.removeChangeListener(changeListener);
        }
    }

    @Override
    protected List<Component> getComponents(Container container) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        if (this.fSpinner.getEditor() instanceof JSpinner.DefaultEditor) {
            arrayList.add(((JSpinner.DefaultEditor)this.fSpinner.getEditor()).getTextField());
        } else {
            arrayList.add((Component)this.fSpinner);
        }
        return arrayList;
    }

    public static void addMouseListenersToSpinner(MJSpinner mJSpinner, MouseListener mouseListener) {
        for (int i = 0; i < mJSpinner.getComponentCount(); ++i) {
            Component component = mJSpinner.getComponent(i);
            if (!(component instanceof JButton)) continue;
            component.addMouseListener(mouseListener);
        }
    }

    private class SpinnerMouseAdapter
    extends MouseAdapter {
        private SpinnerMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            SpinnerWidget.this.fMousedown = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SpinnerWidget.this.fMousedown = false;
            SpinnerWidget.this.set(SpinnerWidget.this.fSpinner.getValue(), (Component)SpinnerWidget.this.fSpinner);
        }
    }
}

