/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class Print
implements Printable {
    private Component printComponent;

    public Print(Component component) {
        this.printComponent = component;
    }

    public void cleanup() {
        this.printComponent = null;
    }

    public void setComponentToPrint(Component component) {
        this.printComponent = component;
    }

    public void print() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (printerJob == null) {
                return;
            }
            printerJob.setPrintable(this);
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n == 0) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                Dimension dimension = this.printComponent.getSize();
                double d = pageFormat.getImageableWidth() / (double)dimension.width;
                double d2 = pageFormat.getImageableHeight() / (double)dimension.height;
                if (d > d2) {
                    graphics2D.scale(d2, d2);
                } else {
                    graphics2D.scale(d, d);
                }
            } else {
                graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            }
            this.printComponent.paint(graphics);
            return 0;
        }
        return 1;
    }
}

