/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.beans.EnumPair;
import com.mathworks.beans.editors.EnumEditor;
import com.mathworks.beans.editors.StringArrayEditor;
import com.mathworks.jmi.bean.DynamicPropertyDescriptor;
import com.mathworks.jmi.bean.UDDPropertyDescription;
import com.mathworks.util.ResLoader;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class UDDBeanInfoUtil {
    private static Hashtable sIconTable = new Hashtable();
    private Class fBeanClass;
    private String fDisplayName;
    private UDDPropertyDescription[] fProperties;
    private PropertyDescriptor[] fPropDescriptors;
    private EventSetDescriptor[] fEventDescriptors;
    private int fPropNum;

    public UDDBeanInfoUtil(Class clazz, String string, UDDPropertyDescription[] uDDPropertyDescriptionArray) {
        this.fBeanClass = clazz;
        this.fDisplayName = string;
        this.fProperties = uDDPropertyDescriptionArray;
    }

    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor beanDescriptor = new BeanDescriptor(this.fBeanClass);
        beanDescriptor.setDisplayName(this.fDisplayName);
        return beanDescriptor;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this.fPropDescriptors == null) {
            try {
                int n;
                int n2 = 0;
                int n3 = this.fProperties.length;
                for (n = 0; n < n3; ++n) {
                    if (this.fProperties[n] == null || this.fProperties[n].isDeprecated()) continue;
                    ++n2;
                }
                this.fPropDescriptors = new PropertyDescriptor[n2];
                n = 0;
                for (UDDPropertyDescription uDDPropertyDescription : this.fProperties) {
                    if (uDDPropertyDescription == null || uDDPropertyDescription.isDeprecated()) continue;
                    EnumPair[] enumPairArray = uDDPropertyDescription.getEnumeration();
                    this.fPropDescriptors[n] = enumPairArray != null ? this.addEnumProperty(uDDPropertyDescription, enumPairArray) : (uDDPropertyDescription.getType().equals("java.lang.String[]") ? this.addNStringsProperty(uDDPropertyDescription) : this.addProperty(uDDPropertyDescription));
                    ++n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fPropDescriptors;
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        if (this.fEventDescriptors == null) {
            this.fEventDescriptors = new EventSetDescriptor[0];
        }
        return this.fEventDescriptors;
    }

    public Image getIcon(int n) {
        Image image = null;
        switch (n) {
            case 1: {
                image = (Image)sIconTable.get(this.fDisplayName);
                break;
            }
        }
        return image;
    }

    private PropertyDescriptor createPropertyDescriptor(UDDPropertyDescription uDDPropertyDescription) throws IntrospectionException {
        Object object;
        Object object2;
        String string = "get" + uDDPropertyDescription.getName();
        String string2 = "set" + uDDPropertyDescription.getName();
        Method method = null;
        if (uDDPropertyDescription.isReadable()) {
            object2 = new Class[]{};
            try {
                method = this.fBeanClass.getMethod(string, (Class<?>)object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object2 = null;
        Class clazz = null;
        if (uDDPropertyDescription.isWriteable()) {
            try {
                clazz = uDDPropertyDescription.getPropertyClass();
                object = new Class[]{clazz};
                try {
                    object2 = this.fBeanClass.getMethod(string2, (Class<?>)object);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = null;
        String string3 = uDDPropertyDescription.getName();
        object = new PropertyDescriptor(string3, method, (Method)object2);
        ((FeatureDescriptor)object).setValue("BeanUtils.SortKey", string3);
        if (!uDDPropertyDescription.isInspectable()) {
            ((FeatureDescriptor)object).setValue("BeanUtils.NoInspectKey", new Object());
        }
        return object;
    }

    public static PropertyDescriptor createDynamicPropertyDescriptor(UDDPropertyDescription uDDPropertyDescription) throws IntrospectionException {
        Class clazz = uDDPropertyDescription.getPropertyClass();
        String string = uDDPropertyDescription.getName();
        DynamicPropertyDescriptor dynamicPropertyDescriptor = new DynamicPropertyDescriptor(string, clazz);
        dynamicPropertyDescriptor.setValue("BeanUtils.SortKey", string);
        if (!uDDPropertyDescription.isInspectable()) {
            dynamicPropertyDescriptor.setValue("BeanUtils.NoInspectKey", new Object());
        }
        return dynamicPropertyDescriptor;
    }

    private PropertyDescriptor addProperty(UDDPropertyDescription uDDPropertyDescription) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = this.createPropertyDescriptor(uDDPropertyDescription);
        return propertyDescriptor;
    }

    private PropertyDescriptor addNStringsProperty(UDDPropertyDescription uDDPropertyDescription) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = this.createPropertyDescriptor(uDDPropertyDescription);
        propertyDescriptor.setPropertyEditorClass(StringArrayEditor.class);
        return propertyDescriptor;
    }

    private PropertyDescriptor addEnumProperty(UDDPropertyDescription uDDPropertyDescription, EnumPair[] enumPairArray) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = this.createPropertyDescriptor(uDDPropertyDescription);
        propertyDescriptor.setPropertyEditorClass(EnumEditor.class);
        propertyDescriptor.setValue("EnumTags", enumPairArray);
        return propertyDescriptor;
    }

    public static void main(String[] stringArray) {
    }

    static {
        ResLoader resLoader = new ResLoader(UDDBeanInfoUtil.class);
        sIconTable.put("uicontrol", resLoader.loadImage("resources/uicontrol.gif"));
        sIconTable.put("figure", resLoader.loadImage("resources/figure.gif"));
        sIconTable.put("axes", resLoader.loadImage("resources/axes.gif"));
        sIconTable.put("uimenu", resLoader.loadImage("resources/uimenu.gif"));
    }
}

