/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.types;

import com.mathworks.jmi.MatlabLooper;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.services.message.MWMessage;
import java.util.Vector;

public class MLArrayRef
implements Runnable {
    public static final int mxUNKNOWN_CLASS = 0;
    public static final int mxCELL_CLASS = 1;
    public static final int mxSTRUCT_CLASS = 2;
    public static final int mxLOGICAL_CLASS = 3;
    public static final int mxCHAR_CLASS = 4;
    private static final int mxSPARSE_CLASS = 5;
    public static final int mxDOUBLE_CLASS = 6;
    public static final int mxSINGLE_CLASS = 7;
    public static final int mxINT8_CLASS = 8;
    public static final int mxUINT8_CLASS = 9;
    public static final int mxINT16_CLASS = 10;
    public static final int mxUINT16_CLASS = 11;
    public static final int mxINT32_CLASS = 12;
    public static final int mxUINT32_CLASS = 13;
    public static final int mxINT64_CLASS = 14;
    public static final int mxUINT64_CLASS = 15;
    public static final int mxFUNCTION_CLASS = 16;
    public static final int mxOPAQUE_CLASS = 17;
    public static final int mxOBJECT_CLASS = 18;
    public static final int COMPLEX = 1;
    public static final int SPARSE = 2;
    private static final int REF_CMD = -15;
    private static final int DISPOSE = 0;
    private static final int GET_DATA = 1;
    private static final int CONVERT_IMAGEDATA = 2;
    private static final int CONVERT_CDATA = 3;
    private static final int CELL_AT = 4;
    private static final int CELL_INFO_AT = 5;
    private static final int IS_CELL_STR = 6;
    private static final int FIELD_AT = 7;
    private static final int FIELD_INFO_AT = 8;
    private static final int FIELD_NAMES = 9;
    private long fRef;
    private int fAttributes;
    private int fType;
    private int[] fDims;
    private MatlabMCR fMatlabMCR;
    private static boolean sDisposePending;
    private static Vector sDispose;

    private static Object createMLArrayRef(long l, int[] nArray, int n, int n2) {
        MLArrayRef mLArrayRef = new MLArrayRef();
        mLArrayRef.fRef = l;
        mLArrayRef.fDims = nArray;
        mLArrayRef.fType = n;
        mLArrayRef.fAttributes = n2;
        return mLArrayRef;
    }

    private static Object createMLArrayRefInNonMatlabThread(long l, int[] nArray, int n, int n2) {
        MLArrayRef mLArrayRef = new MLArrayRef(false);
        mLArrayRef.fRef = l;
        mLArrayRef.fDims = nArray;
        mLArrayRef.fType = n;
        mLArrayRef.fAttributes = n2;
        return mLArrayRef;
    }

    private long getRef() {
        return this.fRef;
    }

    public MLArrayRef() {
        this.fMatlabMCR = MatlabMCRFactory.getForCurrentMCR();
    }

    public MLArrayRef(int n) {
        this.fMatlabMCR = MatlabMCRFactory.getForCurrentMCR();
        if (n >= 1 && n <= 18) {
            this.fType = n;
            this.fDims = new int[2];
        }
    }

    private MLArrayRef(boolean bl) {
        this.fMatlabMCR = MatlabMCRFactory.getForCurrentMCR(bl);
    }

    private static int[] convert2ImageData(MLArrayRef mLArrayRef, boolean bl) {
        int[] nArray = null;
        if (mLArrayRef != null && mLArrayRef.fRef != 0L && mLArrayRef.getNDimensions() == 3 && mLArrayRef.fDims[2] == 3 && (mLArrayRef.isDouble() || mLArrayRef.isUint8())) {
            MWMessage mWMessage = new MWMessage(-15);
            if (bl) {
                mWMessage.addInteger("cmd", 2);
            } else {
                mWMessage.addInteger("cmd", 3);
            }
            mWMessage.addObject("arguments", (Object)mLArrayRef);
            MatlabLooper.postMatlabMessage(mWMessage);
            nArray = (int[])mWMessage.findData("result");
        }
        return nArray;
    }

    public static int[] convertImageData(MLArrayRef mLArrayRef) {
        return MLArrayRef.convert2ImageData(mLArrayRef, false);
    }

    public static int[] convertCData(MLArrayRef mLArrayRef) {
        return MLArrayRef.convert2ImageData(mLArrayRef, true);
    }

    private static void doDispose(MLArrayRef mLArrayRef) {
        if (mLArrayRef.fRef != 0L) {
            MWMessage mWMessage = new MWMessage(-15);
            mWMessage.addInteger("cmd", 0);
            mWMessage.addObject("arguments", (Object)mLArrayRef);
            MatlabLooper.postMatlabMessage(mWMessage);
            mLArrayRef.fRef = 0L;
        }
        mLArrayRef.fDims = null;
        mLArrayRef.fType = 0;
    }

    private static Object doGetData(MLArrayRef mLArrayRef) {
        Object object = null;
        if (mLArrayRef.fRef != 0L) {
            MWMessage mWMessage = new MWMessage(-15);
            mWMessage.addInteger("cmd", 1);
            mWMessage.addObject("arguments", (Object)mLArrayRef);
            MatlabLooper.postMatlabMessage(mWMessage);
            object = mWMessage.findData("result");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRun() {
        Vector vector = sDispose;
        synchronized (vector) {
            sDisposePending = false;
            while (sDispose.size() > 0) {
                MLArrayRef mLArrayRef = (MLArrayRef)sDispose.elementAt(0);
                sDispose.removeElementAt(0);
                MLArrayRef.doDispose(mLArrayRef);
            }
        }
    }

    @Override
    public void run() {
        MLArrayRef.doRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.fRef == 0L) {
            MLArrayRef.doDispose(this);
        } else if (NativeMatlab.nativeIsMatlabThread()) {
            MLArrayRef.doDispose(this);
        } else {
            if (sDispose == null) {
                sDispose = new Vector();
            }
            Vector vector = sDispose;
            synchronized (vector) {
                sDispose.addElement(this);
                if (!sDisposePending) {
                    sDisposePending = true;
                    this.fMatlabMCR.whenMatlabReady(this);
                }
            }
        }
    }

    public void finalize() {
        this.dispose();
    }

    public Object getData() {
        Object object = null;
        if (this.fRef != 0L && NativeMatlab.nativeIsMatlabThread()) {
            object = MLArrayRef.doGetData(this);
        }
        return object;
    }

    public int[] getDimensions() {
        int[] nArray = null;
        if (this.fDims != null) {
            nArray = new int[this.fDims.length];
            System.arraycopy(this.fDims, 0, nArray, 0, this.fDims.length);
        }
        return nArray;
    }

    public int getM() {
        int n = 0;
        if (this.fDims != null) {
            n = this.fDims[0];
        }
        return n;
    }

    public int getN() {
        int n = 0;
        if (this.fDims != null) {
            if (this.fDims.length > 2) {
                n = 1;
                for (int i = 1; i < this.fDims.length; ++i) {
                    n *= this.fDims[i];
                }
            } else {
                n = this.fDims[1];
            }
        }
        return n;
    }

    public int getNDimensions() {
        int n = 0;
        if (this.fDims != null) {
            n = this.fDims.length;
        }
        return n;
    }

    public int getType() {
        return this.fType;
    }

    public boolean isEmpty() {
        return this.getN() == 0;
    }

    public boolean isCell() {
        return this.fType == 1;
    }

    public boolean isChar() {
        return this.fType == 4;
    }

    public boolean isComplex() {
        return (this.fAttributes & 1) != 0;
    }

    public boolean isSparse() {
        return (this.fAttributes & 2) != 0;
    }

    public boolean isStruct() {
        return this.fType == 2;
    }

    public boolean isDouble() {
        return this.fType == 6;
    }

    public boolean isSingle() {
        return this.fType == 7;
    }

    public boolean isInt8() {
        return this.fType == 8;
    }

    public boolean isUint8() {
        return this.fType == 9;
    }

    public boolean isInt16() {
        return this.fType == 10;
    }

    public boolean isUint16() {
        return this.fType == 11;
    }

    public boolean isInt32() {
        return this.fType == 12;
    }

    public boolean isUint32() {
        return this.fType == 13;
    }

    public boolean isInt64() {
        return this.fType == 14;
    }

    public boolean isUint64() {
        return this.fType == 15;
    }

    public boolean isObject() {
        return this.fType == 18;
    }

    public boolean isOpaque() {
        return this.fType == 17;
    }

    public boolean isLogical() {
        return this.fType == 3;
    }

    public boolean isFunctionObject() {
        return this.fType == 16;
    }

    public boolean isUnknown() {
        return this.fType == 0;
    }

    private final String typeToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "unknown";
                break;
            }
            case 1: {
                string = "cell";
                break;
            }
            case 2: {
                string = "struct";
                break;
            }
            case 3: {
                string = "logical";
                break;
            }
            case 4: {
                string = "char";
                break;
            }
            case 5: {
                string = "sparse";
                break;
            }
            case 6: {
                string = "double";
                break;
            }
            case 7: {
                string = "single";
                break;
            }
            case 8: {
                string = "int8";
                break;
            }
            case 9: {
                string = "uint8";
                break;
            }
            case 10: {
                string = "int16";
                break;
            }
            case 11: {
                string = "uint16";
                break;
            }
            case 12: {
                string = "int32";
                break;
            }
            case 13: {
                string = "uint32";
                break;
            }
            case 14: {
                string = "int64";
                break;
            }
            case 15: {
                string = "uint64";
                break;
            }
            case 16: {
                string = "function_handle";
                break;
            }
            case 17: {
                string = "opaque";
                break;
            }
            case 18: {
                string = "unknown";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fDims != null) {
            stringBuffer.append('[');
            if (this.fDims.length > 3) {
                stringBuffer.append(this.fDims.length);
                stringBuffer.append('D');
            } else {
                stringBuffer.append(this.fDims[0]);
                stringBuffer.append('x');
                stringBuffer.append(this.fDims[1]);
                if (this.fDims.length == 3) {
                    stringBuffer.append('x');
                    stringBuffer.append(this.fDims[2]);
                }
            }
            stringBuffer.append("  ");
            stringBuffer.append(this.typeToString(this.fType));
            stringBuffer.append(" array");
            if (this.isSparse()) {
                stringBuffer.append(" (sparse");
                if (this.isComplex()) {
                    stringBuffer.append(" complex");
                }
                stringBuffer.append(")");
            } else if (this.isComplex()) {
                stringBuffer.append(" (complex)");
            }
            stringBuffer.append(']');
        } else {
            stringBuffer.append("[invalid]");
        }
        return stringBuffer.toString();
    }

    public boolean isCellStr() {
        Boolean bl = null;
        if (this.isCell() && this.fRef != 0L) {
            MWMessage mWMessage = new MWMessage(-15);
            mWMessage.addInteger("cmd", 6);
            mWMessage.addObject("arguments", (Object)this);
            MatlabLooper.postMatlabMessage(mWMessage);
            bl = (Boolean)mWMessage.findData("result");
        }
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public MLArrayRef cellInfoAt(int n) {
        return this.doCellAt(5, n);
    }

    public MLArrayRef cellAt(int n) {
        return this.doCellAt(4, n);
    }

    private MLArrayRef doCellAt(int n, int n2) {
        MLArrayRef mLArrayRef = null;
        if (this.isCell() && this.fRef != 0L && (n != 4 || NativeMatlab.nativeIsMatlabThread())) {
            MWMessage mWMessage = new MWMessage(-15);
            mWMessage.addInteger("cmd", n);
            mWMessage.addInteger("value", n2);
            mWMessage.addObject("arguments", (Object)this);
            MatlabLooper.postMatlabMessage(mWMessage);
            mLArrayRef = (MLArrayRef)mWMessage.findData("result");
        }
        return mLArrayRef;
    }

    public String[] fieldNames() {
        String[] stringArray = null;
        if (this.isStruct() && this.fRef != 0L) {
            MWMessage mWMessage = new MWMessage(-15);
            mWMessage.addInteger("cmd", 9);
            mWMessage.addObject("arguments", (Object)this);
            MatlabLooper.postMatlabMessage(mWMessage);
            stringArray = (String[])mWMessage.findData("result");
        }
        return stringArray;
    }

    public MLArrayRef fieldInfoAt(String string, int n) {
        return this.doFieldAt(8, string, n);
    }

    public MLArrayRef fieldAt(String string, int n) {
        return this.doFieldAt(7, string, n);
    }

    private MLArrayRef doFieldAt(int n, String string, int n2) {
        MLArrayRef mLArrayRef = null;
        if (this.isStruct() && this.fRef != 0L && (n != 7 || NativeMatlab.nativeIsMatlabThread())) {
            MWMessage mWMessage = new MWMessage(-15);
            mWMessage.addInteger("cmd", n);
            mWMessage.addInteger("value", n2);
            mWMessage.addObject("string", (Object)string);
            mWMessage.addObject("arguments", (Object)this);
            MatlabLooper.postMatlabMessage(mWMessage);
            mLArrayRef = (MLArrayRef)mWMessage.findData("result");
        }
        return mLArrayRef;
    }
}

