/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.types;

import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.jmi.types.MLArrayRefEditorPanel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.ResLoader;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class MLArrayRefEditor
extends MWPropertyEditorSupport {
    private static Image sIcon = null;
    private MLArrayRefEditorPanel fPanel = null;
    private Object fobjScalar = null;
    private MCOSObject fMCOSObject;

    public Image getIcon() {
        if (sIcon == null) {
            ResLoader resLoader = new ResLoader(((Object)((Object)this)).getClass());
            sIcon = resLoader.loadImage("resources/mlarrayref.gif");
        }
        return sIcon;
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (object instanceof MLArrayRef) {
            MLArrayRef mLArrayRef = (MLArrayRef)object;
            int[] nArray = mLArrayRef.getDimensions();
            try {
                boolean[] blArray = (boolean[])Matlab.mtFeval("isobject", new Object[]{mLArrayRef}, 1);
                if (blArray[0]) {
                    this.setCachedMCOSObject(mLArrayRef);
                    this.setCachedScalar(null);
                    return;
                }
                this.setCachedMCOSObject(null);
            }
            catch (Exception exception) {
                this.setCachedMCOSObject(null);
            }
            if (nArray != null && nArray.length == 2 && nArray[0] == 1 && nArray[1] == 1) {
                this.setCachedScalar(mLArrayRef);
                this.setCachedMCOSObject(null);
            } else {
                this.setCachedScalar(null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized String getAsText() {
        String string = "";
        MLArrayRef mLArrayRef = (MLArrayRef)this.getValue();
        if (mLArrayRef == null) return string;
        int[] nArray = mLArrayRef.getDimensions();
        boolean bl = mLArrayRef.isComplex();
        if (!bl && nArray != null && nArray.length == 2 && nArray[0] == 1 && nArray[1] == 1 && this.fMCOSObject == null) {
            Object object = this.getCachedScalar();
            if (object == null) return string;
            int n = mLArrayRef.getType();
            switch (n) {
                case 7: {
                    if (!(object instanceof float[])) return string;
                    float f = ((float[])object)[0];
                    return "single(" + Float.toString(f) + ")";
                }
                case 6: {
                    if (!(object instanceof double[])) return string;
                    double d = ((double[])object)[0];
                    return Double.toString(d);
                }
                case 8: 
                case 9: {
                    if (!(object instanceof byte[])) return string;
                    byte by = ((byte[])object)[0];
                    short s = by;
                    String string2 = "int8";
                    if (n != 9) return string2 + "(" + Short.toString(s) + ")";
                    if (by < 0) {
                        s = (short)(256 + by);
                    }
                    string2 = "u" + string2;
                    return string2 + "(" + Short.toString(s) + ")";
                }
                case 10: 
                case 11: {
                    int n2;
                    if (!(object instanceof short[])) return string;
                    int n3 = n2 = ((short[])object)[0];
                    String string3 = "int16";
                    if (n != 11) return string3 + "(" + Integer.toString(n3) + ")";
                    if (n2 < 0) {
                        n3 = 65536 + n2;
                    }
                    string3 = "u" + string3;
                    return string3 + "(" + Integer.toString(n3) + ")";
                }
                case 12: 
                case 13: {
                    if (!(object instanceof int[])) return string;
                    int n4 = ((int[])object)[0];
                    long l = n4;
                    String string4 = "int32";
                    if (n != 13) return string4 + "(" + Long.toString(l) + ")";
                    if (n4 < 0) {
                        l = 0x100000000L + (long)n4;
                    }
                    string4 = "u" + string4;
                    return string4 + "(" + Long.toString(l) + ")";
                }
                case 14: 
                case 15: {
                    long l;
                    if (!(object instanceof long[])) return string;
                    long l2 = l = ((long[])object)[0];
                    String string5 = "int64";
                    if (n != 15) return string5 + "(" + Long.toString(l2) + ")";
                    if (l < 0L) {
                        l2 = 0L + l;
                    }
                    string5 = "u" + string5;
                    return string5 + "(" + Long.toString(l2) + ")";
                }
                case 3: {
                    if (!(object instanceof boolean[])) return string;
                    boolean bl2 = ((boolean[])object)[0];
                    return "boolean(" + bl2 + ")";
                }
                default: {
                    return mLArrayRef.toString();
                }
            }
        }
        if (this.fMCOSObject == null) return mLArrayRef.toString();
        return this.fMCOSObject.toString();
    }

    public Object getCachedScalar() {
        return this.fobjScalar;
    }

    private void setCachedScalar(@Nullable Object object) {
        this.fobjScalar = object;
        if (object == null || !(object instanceof MLArrayRef)) {
            this.fobjScalar = null;
            return;
        }
        final MLArrayRef mLArrayRef = (MLArrayRef)object;
        Object object2 = mLArrayRef.getData();
        if (object2 != null) {
            this.fobjScalar = object2;
        } else {
            Matlab.whenMatlabIdle(new Runnable(){

                @Override
                public void run() {
                    MLArrayRefEditor.this.fobjScalar = mLArrayRef.getData();
                }
            });
        }
    }

    private void setCachedMCOSObject(@Nullable MLArrayRef mLArrayRef) {
        if (mLArrayRef == null) {
            this.fMCOSObject = null;
            return;
        }
        try {
            String string = (String)Matlab.mtFeval("class", new Object[]{mLArrayRef}, 1);
            int[] nArray = mLArrayRef.getDimensions();
            this.fMCOSObject = new MCOSObject(string, nArray);
        }
        catch (Exception exception) {
            this.fMCOSObject = null;
        }
    }

    public void setAsText(final String string) {
        Matlab.whenMatlabReady(new Runnable(){

            @Override
            public void run() {
                MLArrayRefEditor.this.setAsText_MatlabThread(string);
            }
        });
    }

    private void setAsText_MatlabThread(String string) {
        if (string != null && string.length() > 0 && string != "") {
            MLArrayRef mLArrayRef = null;
            try {
                mLArrayRef = (MLArrayRef)Matlab.mtFeval("eval", new Object[]{"system_dependent(45," + string + ")"}, 1);
            }
            catch (MatlabException matlabException) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MJOptionPane.showMessageDialog((Component)((Object)MLArrayRefEditor.this.fPanel), (Object)matlabException.getLocalizedMessage(), (String)"", (int)0);
                        Matlab.whenMatlabReady(new Runnable(){

                            @Override
                            public void run() {
                                MLArrayRefEditor.this.setValue(MLArrayRefEditor.this.getValue());
                            }
                        });
                    }
                };
                if (NativeMatlab.nativeIsMatlabThread()) {
                    SwingUtilities.invokeLater(runnable);
                } else {
                    runnable.run();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mLArrayRef != null) {
                this.setValue(mLArrayRef);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public boolean supportsInPlaceEditing() {
        return true;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        MLArrayRef mLArrayRef = (MLArrayRef)this.getValue();
        if (this.fPanel == null) {
            this.fPanel = new MLArrayRefEditorPanel(mLArrayRef);
        } else {
            this.fPanel.setRef(mLArrayRef);
        }
        return this.fPanel;
    }

    public void setPanel(MLArrayRefEditorPanel mLArrayRefEditorPanel) {
        this.fPanel = mLArrayRefEditorPanel;
    }

    public boolean canApply() {
        return true;
    }

    public void apply() {
        if (this.fPanel.isEditing()) {
            this.fPanel.addArrayViewEditingListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MLArrayRefEditor.this.setValue(MLArrayRefEditor.this.fPanel != null ? MLArrayRefEditor.this.fPanel.getRef() : null);
                    MLArrayRefEditor.this.fPanel.removeArrayViewEditingListener(this);
                }
            });
        } else {
            this.setValue(this.fPanel != null ? this.fPanel.getRef() : null);
        }
    }

    public static class MCOSObject {
        private int[] iDimensions;
        private String iClassName;

        public MCOSObject(String string, int[] nArray) {
            assert (nArray != null && nArray.length >= 2);
            this.iDimensions = nArray;
            this.iClassName = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.iDimensions.length >= 3 || this.iDimensions[0] != 1 || this.iDimensions[1] != 1) {
                stringBuilder.append(Integer.toString(this.iDimensions[0]));
                for (int i = 1; i < this.iDimensions.length; ++i) {
                    stringBuilder.append("x");
                    stringBuilder.append(Integer.toString(this.iDimensions[i]));
                }
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.iClassName);
            return stringBuilder.toString();
        }
    }
}

