/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantAbortRecord;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.activation.ActivateFailedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;

public class AbortJob
extends Job
implements TransactionConstants {
    ServerTransaction tr;
    ClientLog log;
    ParticipantHandle[] handles;
    int maxtries = 5;
    static final Logger logger = TxnManagerImpl.participantLogger;

    public AbortJob(Transaction transaction, TaskManager taskManager, WakeupManager wakeupManager, ClientLog clientLog, ParticipantHandle[] participantHandleArray) {
        super(taskManager, wakeupManager);
        if (clientLog == null) {
            throw new IllegalArgumentException("AbortJob: AbortJob: log is null");
        }
        this.log = clientLog;
        if (!(transaction instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)transaction;
        if (participantHandleArray == null) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        if (participantHandleArray.length == 0) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        this.handles = participantHandleArray;
    }

    TaskManager.Task[] createTasks() {
        TaskManager.Task[] taskArray = new TaskManager.Task[this.handles.length];
        for (int i = 0; i < this.handles.length; ++i) {
            taskArray[i] = new ParticipantTask(this.getPool(), this.getMgr(), this, this.handles[i]);
        }
        return taskArray;
    }

    Object doWork(TaskManager.Task task, Object object) {
        ParticipantHandle participantHandle = (ParticipantHandle)object;
        TransactionParticipant transactionParticipant = null;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "AbortJob:doWork aborting handle: {0}", participantHandle);
        }
        int n = 0;
        n = participantHandle.getPrepState();
        switch (n) {
            case 4: 
            case 6: {
                return new Integer(6);
            }
        }
        if (transactionParticipant == null) {
            transactionParticipant = participantHandle.getPreParedParticipant();
        }
        try {
            if (this.attempt(task) > this.maxtries) {
                return new Integer(6);
            }
        }
        catch (JobException jobException) {
            return null;
        }
        if (transactionParticipant == null) {
            return null;
        }
        Integer n2 = null;
        try {
            transactionParticipant.abort(this.tr.mgr, this.tr.id);
            n2 = new Integer(6);
        }
        catch (TransactionException transactionException) {
            n2 = new Integer(6);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            n2 = new Integer(6);
        }
        catch (ConnectException connectException) {
        }
        catch (UnknownHostException unknownHostException) {
            n2 = new Integer(6);
        }
        catch (ConnectIOException connectIOException) {
        }
        catch (MarshalException marshalException) {
            n2 = new Integer(6);
        }
        catch (AccessException accessException) {
            n2 = new Integer(6);
        }
        catch (ActivateFailedException activateFailedException) {
            n2 = new Integer(6);
        }
        catch (RemoteException remoteException) {
        }
        catch (RuntimeException runtimeException) {
            n2 = new Integer(6);
        }
        if (n2 != null) {
            participantHandle.setPrepState(6);
            try {
                this.log.write(new ParticipantAbortRecord(participantHandle));
            }
            catch (LogException logException) {
                // empty catch block
            }
            return n2;
        }
        return null;
    }

    Object computeResult() throws JobException {
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jobNotStartedException) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.results.length; ++i) {
            n = (Integer)this.results[i];
            if (n != 6) continue;
            ++n2;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "AbortJob:computeResult {0} participants ABORTED", new Integer(n2));
        }
        return new Integer(6);
    }
}

