/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.mathworks.messageservice.json.converters.JSONTypeConverter;
import com.mathworks.messageservice.utils.ImageSerializationUtils;
import java.awt.image.BufferedImage;
import java.util.Map;

public class BufferedImageConverter
implements JSONTypeConverter<BufferedImage> {
    @Override
    public BufferedImage deserialize(Map json) {
        return ImageSerializationUtils.getImageFromDataUrl(json.get("__value__").toString());
    }

    @Override
    public JsonElement serialize(BufferedImage src, JsonSerializationContext context) {
        return new JsonPrimitive(new OptimizedImageElementNumber(ImageSerializationUtils.getDataUrlFromImage(src)));
    }

    private static final class OptimizedImageElementNumber
    extends Number {
        private final String data;

        public OptimizedImageElementNumber(String imageDataAsNumber) {
            this.data = "\"" + imageDataAsNumber + "\"";
        }

        @Override
        public int intValue() {
            throw new UnsupportedOperationException("Not Implemented");
        }

        @Override
        public long longValue() {
            throw new UnsupportedOperationException("Not Implemented");
        }

        @Override
        public float floatValue() {
            throw new UnsupportedOperationException("Not Implemented");
        }

        @Override
        public double doubleValue() {
            throw new UnsupportedOperationException("Not Implemented");
        }

        public String toString() {
            return this.data;
        }
    }
}

