/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.transport.rmi;

import com.mathworks.matlabserver.common.config.BootstrapConfigUtil;
import com.mathworks.matlabserver.common.transport.rmi.RMIRegistryManagerExtended;
import com.mathworks.matlabserver.common.transport.rmi.RMIServerEndpoint;
import com.mathworks.matlabserver.common.transport.rmi.RMIServerManagerImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.Remote;

public class RMIServerManagerBootstrapImpl
extends RMIServerManagerImpl {
    public RMIServerManagerBootstrapImpl(String bootstrapUrl, Remote remoteObject, String lookupName) throws IOException {
        BootstrapConfigUtil config = new BootstrapConfigUtil(bootstrapUrl);
        String registryHost = config.loadValue("rmi.host", InetAddress.getLocalHost().getHostName());
        int registryPort = Integer.parseInt(config.loadValue("rmi.port", "1099"));
        RMIServerEndpoint endpoint = new RMIServerEndpoint(0, remoteObject, lookupName);
        this.setupServer(registryHost, registryPort, endpoint);
        this.startServer();
    }

    @Override
    public void setupServer(String registryHost, int registryPort, RMIServerEndpoint rmiServerEndpoint) {
        super.setupServer(registryHost, registryPort, rmiServerEndpoint);
        RMIRegistryManagerExtended rmiRegistryManager = this.getRmiRegistryManager();
        if (!rmiRegistryManager.isValidRegistry()) {
            throw new IllegalStateException("Unable to find the RMI registry");
        }
    }
}

