/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.transport.rmi.message;

import com.mathworks.matlabserver.common.transport.rmi.RMIRegistryManagerInterface;
import com.mathworks.matlabserver.common.transport.rmi.message.MessageServiceRemote;
import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RMIClientMessageManager
implements MessageServiceRemote {
    private final Logger logger = Logger.getLogger(RMIClientMessageManager.class.getName());
    protected final RMIRegistryManagerInterface rmiManager;
    protected final String lookupName;
    protected MessageServiceRemote remoteProxy = null;
    protected final Object guard = new Object();
    private final int retryCount;

    public RMIClientMessageManager(RMIRegistryManagerInterface rmiManager, String lookupName) {
        this(rmiManager, lookupName, 0);
    }

    public RMIClientMessageManager(RMIRegistryManagerInterface rmiManager, String lookupName, int retryCount) {
        this.rmiManager = rmiManager;
        this.lookupName = lookupName;
        this.retryCount = retryCount;
    }

    @Override
    public MessageContainerDO sendMessages(MessageContainerDO messageContainer) {
        return this.sendMessages(messageContainer, this.retryCount);
    }

    public MessageContainerDO sendMessagesWithMLSE(MessageContainerDO messageContainer) {
        return this.sendMessagesWithMLSE(messageContainer, this.retryCount);
    }

    private MessageContainerDO sendMessages(MessageContainerDO messageContainer, int remainingRetryCount) {
        MessageContainerDO result = null;
        try {
            result = this.sendMessagesWithMLSE(messageContainer, remainingRetryCount);
        }
        catch (MLSException mlse) {
            this.logger.warning("RMIClient sendMessages experienced an exception: faultCode = " + mlse.getFaultCode() + " cause = " + mlse.getCause());
        }
        return result;
    }

    private MessageContainerDO sendMessagesWithMLSE(MessageContainerDO messageContainer, int remainingRetryCount) {
        MessageContainerDO retval;
        this.ensureValidRemoteProxy();
        MessageContainerDO messageContainerResponse = null;
        try {
            messageContainerResponse = this.remoteProxy.sendMessages(messageContainer);
        }
        catch (RemoteException e2) {
            this.logger.log(Level.SEVERE, "RMIClientMessageManager caught an Exception of class " + e2.getClass() + " with message " + e2.getMessage(), e2);
            this.remoteProxy = null;
            if (remainingRetryCount > 0) {
                MessageContainerDO messageContainerDO = this.sendMessagesWithMLSE(messageContainer, --remainingRetryCount);
                return messageContainerDO;
            }
            throw new MLSException(e2);
        }
        catch (Exception e3) {
            this.logger.log(Level.SEVERE, "RMIClientMessageManager caught an Exception of class " + e3.getClass() + " with message " + e3.getMessage(), e3);
            this.remoteProxy = null;
            throw new MLSException(e3);
        }
        finally {
            if (messageContainerResponse != null) {
                MessageContainerDO retval2 = messageContainerResponse;
            } else {
                this.logger.severe("messageContainerResponse == null");
                MessageContainerDO retval3 = messageContainer;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureValidRemoteProxy() {
        Object object = this.guard;
        synchronized (object) {
            if (this.remoteProxy == null) {
                Registry registry = this.rmiManager.getRMIRegistry();
                try {
                    this.remoteProxy = (MessageServiceRemote)registry.lookup(this.lookupName);
                }
                catch (Exception e2) {
                    throw new IllegalStateException("No remote proxy available", e2);
                }
            }
        }
    }
}

