/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.util;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SerializeUtil {
    private static final Logger logger = Logger.getLogger(SerializeUtil.class.getName());

    public static Serializable passAcrossClassLoaders(Serializable in) {
        return SerializeUtil.toObject(SerializeUtil.toByte(in));
    }

    private static byte[] toByte(Serializable obj) {
        byte[] retval = null;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bs);
            os.writeObject(obj);
            bs.close();
            os.close();
            retval = bs.toByteArray();
        }
        catch (IOException e2) {
            logger.severe(e2.toString());
        }
        return retval;
    }

    private static Serializable toObject(byte[] bytes) {
        Serializable retval = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object obj = ois.readObject();
            if (obj instanceof Serializable) {
                retval = (Serializable)obj;
            }
        }
        catch (Exception e2) {
            logger.severe(e2.toString());
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toXML(Object obj) {
        String retval = null;
        byte[] bytes = null;
        if (obj != null) {
            XMLEncoder en = null;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                en = new XMLEncoder(bos);
                en.writeObject(obj);
            }
            catch (Exception e2) {
                logger.severe(e2.getMessage());
            }
            finally {
                if (en != null) {
                    en.close();
                    bytes = bos.toByteArray();
                    IOUtils.closeQuietly(bos);
                }
            }
        }
        if (bytes != null) {
            retval = new String(bytes);
        }
        return retval;
    }

    public static <T> T fromXML(String xml, Class<T> theClass) {
        return SerializeUtil.fromXML(xml, theClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromXML(String xml, Class<T> theClass, ClassLoader classLoader) {
        T retval = null;
        if (xml != null) {
            try (XMLDecoder decoder = null;){
                ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
                decoder = new XMLDecoder(bis, null, null, classLoader);
                Object obj = decoder.readObject();
                retval = theClass.cast(obj);
            }
        }
        return retval;
    }

    public static String toBase64(Object obj) throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bs);
        os.writeObject(obj);
        bs.close();
        os.close();
        return new BASE64Encoder().encode(bs.toByteArray());
    }

    public static Object fromBase64(String str) throws Exception {
        byte[] bytes = new BASE64Decoder().decodeBuffer(str);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        return ois.readObject();
    }

    public static byte[] createByteArray(Object obj) {
        return SerializeUtil.toByte((Serializable)obj);
    }
}

