/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.editordataservice;

import com.mathworks.matlabserver.editordataservice.Document;
import com.mathworks.matlabserver.editordataservice.EditorFeature;
import com.mathworks.matlabserver.editordataservice.EditorNodeUtilities;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class EditorNode {
    private static boolean sLoggingErrors;
    private final PeerNode fNode;
    private final Document fDocument;
    private final List<EditorFeature> fActiveFeatures = new ArrayList<EditorFeature>();
    private final Map<String, List<String>> fFeaturesLibrary;

    public EditorNode(PeerNode node, Map<String, List<String>> featuresLibrary) {
        this.fNode = node;
        this.fFeaturesLibrary = featuresLibrary;
        this.fDocument = new Document(EditorNodeUtilities.getUniqueIdFromNode(node));
        this.addDocumentChangedListener();
        this.addFeatureRegisterListener();
    }

    private void addFeatureRegisterListener() {
        this.fNode.addPeerEventListener("registerFeature", new Observer(){

            public void handle(Event event) {
                if (EditorNodeUtilities.isFeatureRegisterEvent(event) && !EditorNode.this.hasFeature(EditorNodeUtilities.getFeatureIdFromEvent(event))) {
                    EditorNode.this.attachFeature(EditorNodeUtilities.getFeatureIdFromEvent(event));
                }
            }
        });
    }

    private void addDocumentChangedListener() {
        this.fNode.addPeerEventListener("documentChanged", new Observer(){

            public void handle(Event event) {
                if (EditorNodeUtilities.isDocumentChanged(event)) {
                    EditorNode.this.updateText(EditorNodeUtilities.getDocumentTextFromEvent(event));
                }
            }
        });
    }

    private void attachFeature(String featureId) {
        block2: for (String ids : this.fFeaturesLibrary.keySet()) {
            List<String> featureClassNames;
            if (!ids.equals(featureId) || (featureClassNames = this.fFeaturesLibrary.get(featureId)) == null) continue;
            for (String className : featureClassNames) {
                try {
                    EditorFeature feature = EditorNodeUtilities.constructEditorFeatureInstance(this, className);
                    if (feature == null) continue;
                    this.addFeature(feature);
                    continue block2;
                }
                catch (Exception e2) {
                    if (!EditorNode.shouldLogAddFeatureError()) continue;
                    e2.printStackTrace();
                }
            }
        }
    }

    private static boolean shouldLogAddFeatureError() {
        return sLoggingErrors;
    }

    public static void setAddFeatureExceptionLogging(boolean shouldLog) {
        sLoggingErrors = shouldLog;
    }

    void updateFeatureData(String featureId, Map data) {
        this.fNode.setProperty(featureId, (Object)data);
    }

    private boolean hasFeature(String featureId) {
        boolean hasFeature = false;
        for (EditorFeature feature : this.fActiveFeatures) {
            if (!featureId.equals(feature.getFeatureId())) continue;
            hasFeature = true;
            break;
        }
        return hasFeature;
    }

    private void addFeature(EditorFeature feature) {
        this.fActiveFeatures.add(feature);
        feature.documentChanged(this.fDocument);
    }

    private synchronized void updateText(String text) {
        this.fDocument.replaceText(text);
        for (EditorFeature feature : this.fActiveFeatures) {
            try {
                feature.documentChanged(this.fDocument);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void dispose() {
        for (EditorFeature feature : this.fActiveFeatures) {
            feature.dispose();
        }
    }
}

