/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.decorator;

import com.mathworks.matlabserver.fileservices.decorator.FileServiceAbstractDecorator;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FilePermissionsDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;

public class FileServiceMountPermissionDecorator
extends FileServiceAbstractDecorator {
    public FileServiceMountPermissionDecorator(FileService fileService) {
        super(fileService);
    }

    @Override
    public FileInfoDO readInfo(UserTokenDO userToken, FileInfoDO fileInfo) {
        FileInfoDO retFileInfo = super.readInfo(userToken, fileInfo);
        this.addMountPermissions(retFileInfo);
        return retFileInfo;
    }

    @Override
    public FileDO read(UserTokenDO userToken, FileInfoDO fileInfo) {
        FileDO file = super.read(userToken, fileInfo);
        this.addMountPermissions(file.getFileInfo());
        return file;
    }

    @Override
    public FileDO open(UserTokenDO userToken, FileInfoDO fileInfo) {
        FileDO file = super.open(userToken, fileInfo);
        this.addMountPermissions(file.getFileInfo());
        return file;
    }

    protected void addMountPermissions(FileInfoDO fileInfo) {
        String location;
        FilePermissionsDO permissions = fileInfo.getFilePermissions();
        if (permissions == null) {
            permissions = new FilePermissionsDO();
            permissions.setCanWrite(true);
            fileInfo.setFilePermissions(permissions);
        }
        if (permissions.isCanWrite() && (location = fileInfo.getLocation()) != null) {
            boolean canWrite = location.startsWith(this.getWorkerMountPoint());
            permissions.setCanWrite(canWrite);
        }
    }
}

