/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.impl;

import com.mathworks.matlabserver.common.fileservice.FileUtils;
import com.mathworks.matlabserver.fileservices.impl.WebdavClient;
import com.mathworks.matlabserver.fileservices.impl.WebdavClientImpl;
import com.mathworks.matlabserver.fileservices.policy.MetadataProviderManager;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.file.FileServiceMessageFaultDO;
import com.mathworks.matlabserver.internalservices.path.PathManager;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.util.HttpDateFormat;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Node;

public class FileServiceWebdavImpl
implements FileService {
    private static final Logger logger = Logger.getLogger(FileServiceWebdavImpl.class.getName());
    private final FilenameConverter filenameConverter;
    private final WebdavClient webdavClient;
    private static final ThreadLocal<DateFormat> creationDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new HttpDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        }
    };
    private static final ThreadLocal<DateFormat> modificationDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new HttpDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        }
    };
    private boolean versioningEnabled = false;
    private static final String SESSION_FOLDER = ".session";
    private boolean versionSessions = false;
    private ExecutorService asyncExecutor = Executors.newCachedThreadPool();
    private PathManager pathManager = null;
    private final MetadataProviderManager metadataProvider;

    public FileServiceWebdavImpl(FilenameConverter filenameConverter) {
        this.filenameConverter = filenameConverter;
        this.webdavClient = new WebdavClientImpl(filenameConverter.getServerMountPoint());
        this.metadataProvider = new MetadataProviderManager();
        logger.setLevel(Level.INFO);
    }

    public FileServiceWebdavImpl(FilenameConverter filenameConverter, WebdavClient webdavClient) {
        this.filenameConverter = filenameConverter;
        this.webdavClient = webdavClient;
        this.metadataProvider = new MetadataProviderManager();
        logger.setLevel(Level.INFO);
    }

    public FileServiceWebdavImpl(FilenameConverter filenameConverter, WebdavClientImpl webdavClient, PathManager pathManager) {
        this(filenameConverter, webdavClient);
        this.pathManager = pathManager;
    }

    @Override
    public InputStream readContent(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        String fileUrl = this.filenameConverter.getServerFilename(userToken, fileInfo);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        byte[] data = this.webdavClient.getFile(client, fileUrl);
        return new ByteArrayInputStream(data);
    }

    @Override
    public FileInfoDO updateContent(UserTokenDO userToken, FileInfoDO fileInfo, InputStream contents) throws MLSException {
        String fileUrl = this.filenameConverter.getServerFilename(userToken, fileInfo);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        try {
            if (this.shouldVersion(fileUrl)) {
                this.webdavClient.checkout(client, fileUrl);
            }
            byte[] data = IOUtils.toByteArray(contents);
            this.webdavClient.putFile(client, fileUrl, data);
            if (this.shouldVersion(fileUrl)) {
                this.webdavClient.checkin(client, fileUrl);
            }
        }
        catch (IOException e2) {
            String message = "Unable to update the file contents: " + e2.getMessage();
            logger.severe(message);
            throw this.createMLSException(e2, message, fileInfo);
        }
        boolean forceRefresh = true;
        fileInfo = this.metadataProvider.addMetadata(fileInfo, forceRefresh);
        return fileInfo;
    }

    @Override
    public FileInfoDO readInfo(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        String fileUrl = this.filenameConverter.getServerFilename(userToken, fileInfo);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        FileInfoDO newFileInfo = this.getFileInfo(client, fileUrl, userToken);
        if (newFileInfo == null) {
            throw this.createMLSException("Could not read file info: " + fileInfo, fileInfo);
        }
        newFileInfo.setType(fileInfo.getType());
        return newFileInfo;
    }

    @Override
    public FileInfoDO updateInfo(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        boolean forceRefresh = true;
        fileInfo = this.metadataProvider.addMetadata(fileInfo, forceRefresh);
        return fileInfo;
    }

    @Override
    public boolean exists(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        boolean fileExists;
        String fileUrl = this.filenameConverter.getServerFilename(userToken, fileInfo);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        try {
            fileExists = this.fileExists(client, fileUrl);
        }
        catch (Exception e2) {
            String message = "Error trying to determine if a file exists or not.";
            logger.warning(message);
            throw this.createMLSException(e2, message, fileInfo);
        }
        return fileExists;
    }

    @Override
    public FileInfoDO create(UserTokenDO userToken, FileDO file) throws MLSException {
        String fileUrl = this.filenameConverter.getServerFilename(userToken, file.getFileInfo());
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        if (this.fileExists(client, fileUrl)) {
            throw this.createMLSException("Can't create a file that already exists.", file.getFileInfo());
        }
        this.createParentFolder(userToken, client, fileUrl);
        if (file.getFileInfo().isDirectory()) {
            this.putFolder(userToken, client, fileUrl);
        } else {
            byte[] bytes = file.getData();
            if (bytes == null) {
                bytes = new byte[]{};
            }
            this.webdavClient.putFile(client, fileUrl, bytes);
            if (this.shouldVersion(fileUrl)) {
                this.webdavClient.versionControl(client, fileUrl);
                this.webdavClient.checkin(client, fileUrl);
            }
        }
        return this.getFileInfo(client, fileUrl, userToken);
    }

    @Override
    public FileDO read(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        InputStream stream = null;
        FileDO file = null;
        try {
            stream = this.readContent(userToken, fileInfo);
            file = new FileDO();
            file.setData(IOUtils.toByteArray(stream));
            FileInfoDO updatedFileInfo = this.readInfo(userToken, fileInfo);
            file.setFileInfo(updatedFileInfo);
        }
        catch (Exception e2) {
            try {
                String message = "Error reading the bytes from the stream";
                logger.log(Level.SEVERE, message, e2);
                throw this.createMLSException(e2, message, fileInfo);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(stream);
        return file;
    }

    @Override
    public FileDO open(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        return this.read(userToken, fileInfo);
    }

    @Override
    public FileInfoDO update(UserTokenDO userToken, FileDO file) throws MLSException {
        String fileUrl = this.filenameConverter.getServerFilename(userToken, file.getFileInfo());
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        FileInfoDO fileInfo = this.getFileInfo(client, fileUrl, userToken);
        if (fileInfo == null) {
            throw this.createMLSException("Can't update a file that doesn't exist.", fileInfo);
        }
        if (fileInfo.isDirectory()) {
            throw this.createMLSException("Can't update a directory.", fileInfo);
        }
        if (this.shouldVersion(fileUrl)) {
            this.webdavClient.checkout(client, fileUrl);
        }
        byte[] bytes = file.getData();
        this.webdavClient.putFile(client, fileUrl, bytes);
        if (this.shouldVersion(fileUrl)) {
            this.webdavClient.checkin(client, fileUrl);
        }
        return this.getFileInfo(client, fileUrl, userToken);
    }

    @Override
    public FileInfoDO close(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        boolean forceRefresh = true;
        fileInfo = this.metadataProvider.addMetadata(fileInfo, forceRefresh);
        return fileInfo;
    }

    @Override
    public FileInfoDO delete(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        String fileUrl = this.filenameConverter.getServerFilename(userToken, fileInfo);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        this.webdavClient.deleteFile(client, fileUrl);
        fileInfo.setDeleted(true);
        boolean forceRefresh = true;
        fileInfo = this.metadataProvider.addMetadata(fileInfo, forceRefresh);
        return fileInfo;
    }

    @Override
    public FileInfoDO[] delete(UserTokenDO userToken, FileInfoDO[] fileInfoArray) throws MLSException {
        MLSException error = null;
        for (FileInfoDO fileInfoDO : fileInfoArray) {
            if (fileInfoDO == null) continue;
            try {
                this.delete(userToken, fileInfoDO);
            }
            catch (MLSException e2) {
                error = e2;
            }
        }
        if (error != null) {
            logger.log(Level.WARNING, "File delete failed for one of the files.");
            throw error;
        }
        boolean forceRefresh = true;
        fileInfoArray = this.metadataProvider.addMetadata(fileInfoArray, forceRefresh);
        return fileInfoArray;
    }

    public FileInfoDO move(UserTokenDO userToken, FileInfoDO sourceFileInfo, FileInfoDO destinationFileInfo) throws MLSException {
        String sourceFileUrl = this.filenameConverter.getServerFilename(userToken, sourceFileInfo);
        String destinationFileUrl = this.filenameConverter.getServerFilename(userToken, destinationFileInfo);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        FileInfoDO realDestinationFolderInfo = this.getFileInfo(client, destinationFileUrl, userToken);
        if (realDestinationFolderInfo != null && !realDestinationFolderInfo.isDirectory()) {
            logger.log(Level.WARNING, "Destination is not a folder");
            throw new MLSException("FileService.IOError", "Destination is not a folder");
        }
        if (realDestinationFolderInfo == null) {
            this.createParentFolder(userToken, client, destinationFileUrl);
            this.putFolder(userToken, client, destinationFileUrl);
        }
        int lastSeparator = sourceFileUrl.lastIndexOf(this.filenameConverter.getServerFileSeparator());
        String sourceFileName = sourceFileUrl.substring(lastSeparator);
        this.moveFile(userToken, client, sourceFileUrl, destinationFileUrl + sourceFileName);
        return this.getFileInfo(client, destinationFileUrl + sourceFileName, userToken);
    }

    @Override
    public FileInfoDO[] move(UserTokenDO userToken, FileInfoDO[] sourceFileInfoArray, FileInfoDO destinationFileInfo) throws MLSException {
        ArrayList<FileInfoDO> newFileInfoList = new ArrayList<FileInfoDO>();
        MLSException error = null;
        for (FileInfoDO sourceFileInfoDO : sourceFileInfoArray) {
            if (sourceFileInfoDO == null) continue;
            try {
                sourceFileInfoDO = this.move(userToken, sourceFileInfoDO, destinationFileInfo);
                newFileInfoList.add(sourceFileInfoDO);
            }
            catch (MLSException e2) {
                error = e2;
            }
        }
        if (error != null) {
            logger.log(Level.WARNING, "File move failed for one of the files.");
            throw error;
        }
        FileInfoDO[] fileInfoArray = new FileInfoDO[newFileInfoList.size()];
        fileInfoArray = newFileInfoList.toArray(fileInfoArray);
        boolean forceRefresh = true;
        fileInfoArray = this.metadataProvider.addMetadata(fileInfoArray, forceRefresh);
        return fileInfoArray;
    }

    @Override
    public FileInfoDO rename(UserTokenDO userToken, FileInfoDO originalFileInfo, FileInfoDO newFileInfo) throws MLSException {
        String originalFileUrl = this.filenameConverter.getServerFilename(userToken, originalFileInfo);
        String newFileUrl = this.filenameConverter.getServerFilename(userToken, newFileInfo);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        this.moveFile(userToken, client, originalFileUrl, newFileUrl);
        newFileInfo = this.getFileInfo(client, newFileUrl, userToken);
        newFileInfo.setDirectory(this.retreiveIsDirectory(client, newFileUrl));
        return newFileInfo;
    }

    @Override
    public FileInfoDO[] list(UserTokenDO userToken, FileInfoDO directory) throws MLSException {
        String fileUrl = this.filenameConverter.getServerFilename(userToken, directory);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        MultiStatusResponse[] responses = this.webdavClient.getAllProperties(client, fileUrl, 1);
        if (responses == null) {
            throw this.createMLSException("Unable to get all properties for " + fileUrl, directory);
        }
        fileUrl = FileUtils.ufsUriDecode(fileUrl);
        ArrayList<FileInfoDO> fileInfoList = new ArrayList<FileInfoDO>();
        for (MultiStatusResponse response : responses) {
            String filename = response.getHref();
            filename = filename.endsWith("/") ? filename.substring(0, filename.length() - 1) : filename;
            if ((filename = FileUtils.ufsUriDecode(filename)).equals(fileUrl)) continue;
            logger.finest("adding file: " + filename + " [" + fileUrl + "]");
            fileInfoList.add(this.convertToFileInfo(userToken, response));
        }
        FileInfoDO[] fileInfoArray = new FileInfoDO[fileInfoList.size()];
        fileInfoArray = fileInfoList.toArray(fileInfoArray);
        return fileInfoArray;
    }

    private FileInfoDO getFileInfo(HttpClient client, String fileUrl, UserTokenDO userToken) {
        MultiStatusResponse[] responses = this.webdavClient.getAllProperties(client, fileUrl, 0);
        FileInfoDO fileInfo = null;
        if (responses != null && responses.length == 1) {
            fileInfo = this.convertToFileInfo(userToken, responses[0]);
        }
        return fileInfo;
    }

    private FileInfoDO convertToFileInfo(UserTokenDO userToken, MultiStatusResponse response) {
        String filename = this.getServerFilename(response);
        filename = this.filenameConverter.convertFilenameFromServerToWorker(userToken, filename);
        FileInfoDO fileInfo = new FileInfoDO();
        fileInfo.setName(FilenameUtils.getName(filename));
        fileInfo.setLocation(FilenameUtils.getFullPath(filename));
        this.updateFileInfo(fileInfo, response.getProperties(200));
        return fileInfo;
    }

    private void updateFileInfo(FileInfoDO fileInfo, DavPropertySet properties) {
        DavPropertyName contentLengthName;
        Node type;
        DavPropertyName resourceTypeName;
        DavPropertyName lastModifiedName;
        this.logProperties(properties);
        DavPropertyName creationDateName = DavPropertyName.create((String)"creationdate", (Namespace)DavPropertyName.NAMESPACE);
        if (properties.contains(creationDateName)) {
            String creation = (String)properties.get(creationDateName).getValue();
            try {
                fileInfo.setCreated(this.getCreationDateFormat().parse(creation));
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Unable to parse creation date: " + creation, e2);
            }
        }
        if (properties.contains(lastModifiedName = DavPropertyName.create((String)"getlastmodified", (Namespace)DavPropertyName.NAMESPACE))) {
            String lastModified = (String)properties.get(lastModifiedName).getValue();
            try {
                fileInfo.setModified(this.getModificationDateFormat().parse(lastModified));
            }
            catch (Exception e3) {
                logger.log(Level.SEVERE, "Unable to parse modification date: " + lastModified, e3);
            }
        }
        if (properties.contains(resourceTypeName = DavPropertyName.create((String)"resourcetype", (Namespace)DavPropertyName.NAMESPACE)) && (type = (Node)properties.get(resourceTypeName).getValue()) != null) {
            fileInfo.setDirectory(type.getLocalName().equals("collection"));
        }
        if (properties.contains(contentLengthName = DavPropertyName.create((String)"getcontentlength", (Namespace)DavPropertyName.NAMESPACE))) {
            long size = Long.parseLong((String)properties.get(contentLengthName).getValue());
            fileInfo.setSize(size);
        }
        boolean forceRefresh = true;
        this.metadataProvider.addMetadata(fileInfo, this.isShared(properties), forceRefresh);
    }

    private boolean isShared(DavPropertySet properties) {
        Namespace namespace;
        DavPropertyName sharingProperty;
        boolean isShared = false;
        if (properties != null && properties.contains(sharingProperty = DavPropertyName.create((String)"isShared", (Namespace)(namespace = Namespace.getNamespace((String)"mls"))))) {
            String isSharedValue = (String)properties.get(sharingProperty).getValue();
            isShared = "true".equalsIgnoreCase(isSharedValue);
        }
        return isShared;
    }

    private void logProperties(DavPropertySet properties) {
        if (properties != null) {
            DavPropertyName[] propertyNames;
            for (DavPropertyName propertyName : propertyNames = properties.getPropertyNames()) {
                String val;
                DavProperty property = properties.get(propertyName);
                if (property == null || property.getValue() == null || !(val = property.getValue().toString()).contains("description")) continue;
                logger.finest("Property " + propertyName.getName() + ", Value: " + property.getValue());
            }
        }
    }

    protected DateFormat getCreationDateFormat() {
        return creationDateFormat.get();
    }

    protected DateFormat getModificationDateFormat() {
        return modificationDateFormat.get();
    }

    private String getServerFilename(MultiStatusResponse response) {
        String filename = response.getHref();
        try {
            filename = URIUtil.encodePath((String)URIUtil.decode((String)filename));
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        return filename.endsWith(this.filenameConverter.getServerFileSeparator()) ? filename.substring(0, filename.length() - 1) : filename;
    }

    private boolean fileExists(HttpClient client, String fileUrl) {
        MultiStatusResponse response;
        DavPropertySet properties;
        MultiStatusResponse[] responses = this.webdavClient.getProperty(client, fileUrl, DavPropertyName.DISPLAYNAME, 0);
        boolean fileExists = false;
        if (responses != null && responses.length == 1 && (properties = (response = responses[0]).getProperties(200)) != null && !properties.isEmpty()) {
            fileExists = true;
        }
        return fileExists;
    }

    private void createParentFolder(UserTokenDO userToken, HttpClient client, String fileUrl) {
        int lastSeparator = fileUrl.lastIndexOf(this.filenameConverter.getServerFileSeparator());
        String parentUrl = fileUrl.substring(0, lastSeparator);
        if (!this.fileExists(client, parentUrl)) {
            this.createParentFolder(userToken, client, parentUrl);
            this.putFolder(userToken, client, parentUrl);
        }
    }

    private void putFolder(UserTokenDO userToken, HttpClient client, String fileUrl) {
        this.webdavClient.putFolder(client, fileUrl);
        if (this.pathManager != null) {
            final String folder = this.filenameConverter.convertFilenameFromServerToWorker(userToken, fileUrl);
            this.asyncExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("Adding folder to path: " + folder);
                    FileServiceWebdavImpl.this.pathManager.addFolderToPath(folder);
                }
            });
        }
    }

    private void moveFile(final UserTokenDO userToken, final HttpClient client, final String originalFileUrl, final String newFileUrl) {
        this.webdavClient.moveFile(client, originalFileUrl, newFileUrl);
        if (this.pathManager != null) {
            this.asyncExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (FileServiceWebdavImpl.this.retreiveIsDirectory(client, newFileUrl)) {
                        String originalFolder = FileServiceWebdavImpl.this.filenameConverter.convertFilenameFromServerToWorker(userToken, originalFileUrl);
                        String newFolder = FileServiceWebdavImpl.this.filenameConverter.convertFilenameFromServerToWorker(userToken, newFileUrl);
                        logger.info("Moving folder on the path: " + originalFolder + " to " + newFolder);
                        FileServiceWebdavImpl.this.pathManager.moveFolderOnPath(originalFolder, newFolder);
                    }
                }
            });
        }
    }

    private boolean retreiveIsDirectory(HttpClient client, String fileUrl) {
        Node type;
        DavPropertySet properties;
        DavPropertyName resourceTypeName = DavPropertyName.create((String)"resourcetype", (Namespace)DavPropertyName.NAMESPACE);
        MultiStatusResponse[] responses = this.webdavClient.getProperty(client, fileUrl, resourceTypeName, 0);
        boolean isFolder = false;
        if (responses.length == 1 && (properties = responses[0].getProperties(200)).contains(resourceTypeName) && (type = (Node)properties.get(resourceTypeName).getValue()) != null && type.getLocalName().equals("collection")) {
            isFolder = true;
        }
        return isFolder;
    }

    private boolean shouldVersion(String fileUrl) {
        return this.isVersioningEnabled() && (this.isVersionSessions() || !fileUrl.contains(SESSION_FOLDER));
    }

    @Override
    public String getWorkerMountPoint() {
        return this.filenameConverter.getWorkerMountPoint();
    }

    @Override
    public String getWorkerMountPoint(UserTokenDO userToken) {
        return this.filenameConverter.getWorkerMountPoint(userToken);
    }

    @Override
    public String getServerMountPoint() {
        return this.filenameConverter.getServerMountPoint();
    }

    @Override
    public String getServerMountPoint(UserTokenDO userToken) {
        return this.filenameConverter.getServerMountPoint(userToken);
    }

    private MLSException createMLSException(String message, FileInfoDO fileInfo) {
        FileServiceMessageFaultDO fault = new FileServiceMessageFaultDO("FileService.IOError", message, fileInfo);
        return new MLSException(fault);
    }

    private MLSException createMLSException(Exception e2, String message, FileInfoDO fileInfo) {
        FileServiceMessageFaultDO fault = new FileServiceMessageFaultDO("FileService.IOError", message, fileInfo);
        return new MLSException(fault, (Throwable)e2);
    }

    public boolean isVersioningEnabled() {
        return this.versioningEnabled;
    }

    public void setVersioningEnabled(boolean versioningEnabled) {
        this.versioningEnabled = versioningEnabled;
    }

    public boolean isVersionSessions() {
        return this.versionSessions;
    }

    public void setVersionSessions(boolean versionSessions) {
        this.versionSessions = versionSessions;
    }
}

