/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.message;

import com.mathworks.matlabserver.fileservices.message.FileHandlerUtils;
import com.mathworks.matlabserver.fileservices.message.ListFileHandler;
import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.faults.MessageFaultDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.file.ListFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.ListFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.util.List;
import java.util.logging.Logger;

public class ListFileHandlerImpl
implements ListFileHandler {
    private final Logger logger = Logger.getLogger(ListFileHandlerImpl.class.getName());

    @Override
    public void handleListFileRequest(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<ListFileRequestMessageDO> list = messageContainer.getMessages(ListFileRequestMessageDO.class);
        for (ListFileRequestMessageDO listFileRequest : list) {
            if (listFileRequest == null) continue;
            messageContainer.consumeMessage(ListFileRequestMessageDO.class);
            ListFileResponseMessageDO listFileResponse = new ListFileResponseMessageDO();
            messageContainer.addMessage(ListFileResponseMessageDO.class, listFileResponse);
            listFileResponse.setUuid(listFileRequest.getUuid());
            try {
                FileInfoDO fileInfo = listFileRequest.getFileInfo();
                if (fileInfo != null) {
                    FileInfoDO safeFileInfo = new FileInfoDO();
                    safeFileInfo.setLocation(fileInfo.getLocation());
                    safeFileInfo.setName(fileInfo.getName());
                    FileInfoDO folder = fileService.readInfo(userToken, fileInfo);
                    listFileResponse.setFolder(folder);
                    FileInfoDO[] fileArray = fileService.list(userToken, safeFileInfo);
                    listFileResponse.setFileInfoArray(FileHandlerUtils.removeHiddenFilesAndDirs(fileArray));
                    continue;
                }
                this.logger.warning("ListFileRequestMessageDO is missing a fileInfo parameter");
                MessageFaultDO messageFault = new MessageFaultDO();
                messageFault.setFaultCode("Request.Ignored");
                messageFault.setMessage("Missing parameter");
                listFileResponse.setFault(messageFault);
            }
            catch (MLSException e2) {
                FileHandlerUtils.setResponseFault(listFileResponse, e2);
            }
        }
    }
}

