/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.util;

import com.mathworks.matlabserver.common.fileservice.FileUtils;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class FilenameConverterBase
implements FilenameConverter {
    private static final Logger logger = Logger.getLogger(FilenameConverterBase.class.getName());
    private final String workerFileSeparator;
    private final String serverFileSeparator;
    private final String workerMountPoint;
    private final String serverMountPoint;
    private String adminId = "admin";

    public FilenameConverterBase(String serverMountPoint, String workerMountPoint, String serverFileSeparator, String workerFileSeparator) {
        this.serverMountPoint = serverMountPoint;
        this.workerMountPoint = workerMountPoint;
        this.serverFileSeparator = serverFileSeparator;
        this.workerFileSeparator = workerFileSeparator;
    }

    @Override
    public String getServerFilename(UserTokenDO userToken, FileInfoDO fileInfo) {
        String filename = this.getWorkerFilename(userToken, fileInfo);
        return this.convertFilenameFromWorkerToServer(userToken, filename);
    }

    @Override
    public String getWorkerFilename(UserTokenDO userToken, FileInfoDO fileInfo) {
        String filename = FilenameUtils.normalizeNoEndSeparator(fileInfo.getLocation());
        if (!this.getWorkerFileSeparator().equals(File.separator)) {
            filename = filename.replace(File.separator, this.getWorkerFileSeparator());
        }
        if (filename.endsWith(this.getWorkerFileSeparator())) {
            filename = filename.substring(0, filename.length() - this.getWorkerFileSeparator().length());
        }
        if (filename.length() > 0) {
            filename = filename + this.getWorkerFileSeparator();
        }
        filename = this.unMapFromWorker(userToken, filename + fileInfo.getName());
        this.validateFileName(userToken, filename);
        return this.mapToWorker(userToken, filename);
    }

    @Override
    public String convertFilenameFromWorkerToServer(UserTokenDO userToken, String filename) {
        logger.finest("worker filename: " + filename);
        filename = this.unMapFromWorker(userToken, filename);
        logger.finest("un-mapped filename: " + filename);
        this.validateFileName(userToken, filename);
        filename = this.mapToServer(userToken, filename);
        logger.finest("server filename: " + filename);
        return filename;
    }

    @Override
    public String convertFilenameFromServerToWorker(UserTokenDO userToken, String filename) {
        logger.finest("server filename: " + filename);
        filename = this.unMapFromServer(userToken, filename);
        logger.finest("un-mapped filename: " + filename);
        this.validateFileName(userToken, filename);
        filename = this.mapToWorker(userToken, filename);
        logger.finest("worker filename: " + filename);
        return filename;
    }

    protected String unMapFromWorker(UserTokenDO userToken, String filename) {
        String workerUserRoot = this.getWorkerMountPoint(userToken);
        if (userToken.getName().equals(this.adminId) && filename.startsWith(this.getWorkerMountPoint())) {
            filename = filename.substring(this.getWorkerMountPoint().length());
        } else if (filename.startsWith(workerUserRoot)) {
            filename = filename.substring(workerUserRoot.length());
        }
        return this.translateFilenameToInternalForm(filename);
    }

    protected String translateFilenameToInternalForm(String filename) {
        filename = FilenameUtils.separatorsToUnix(filename);
        if (!(filename = filename.replaceAll("//", "/")).startsWith("/")) {
            filename = "/" + filename;
        }
        return filename;
    }

    protected String unMapFromServer(UserTokenDO userToken, String filename) {
        String serverUserRoot = this.getServerMountPoint(userToken);
        if (userToken.getName().equals(this.adminId) && filename.startsWith(this.getServerMountPoint())) {
            filename = filename.substring(this.getServerMountPoint().length());
        } else if (filename.startsWith(serverUserRoot)) {
            filename = filename.substring(serverUserRoot.length());
        }
        filename = FilenameUtils.separatorsToUnix(filename);
        filename = filename.replaceAll("//", "/");
        return filename;
    }

    protected String mapToWorker(UserTokenDO userToken, String filename) {
        filename = filename.replace("/", this.getWorkerFileSeparator());
        filename = userToken.getName().equals(this.adminId) ? this.getWorkerMountPoint() + filename : this.getWorkerMountPoint(userToken) + filename;
        return filename.endsWith(this.getWorkerFileSeparator()) ? filename.substring(0, filename.length() - this.getWorkerFileSeparator().length()) : filename;
    }

    protected String mapToServer(UserTokenDO userToken, String filename) {
        filename = filename.replace("/", this.getServerFileSeparator());
        filename = userToken.getName().equals(this.adminId) ? this.getServerMountPoint() + filename : this.getServerMountPoint(userToken) + filename;
        return filename.endsWith(this.getServerFileSeparator()) ? filename.substring(0, filename.length() - this.getServerFileSeparator().length()) : filename;
    }

    protected void validateFileName(UserTokenDO userToken, String filename) throws MLSException {
        String normalizedFileName = FilenameUtils.normalize(filename);
        if (!this.normalizedFileNameNeedsConversion(normalizedFileName)) {
            String message = "Illegal file access attempt by user: " + userToken.getName() + " trying to get at file: " + normalizedFileName;
            logger.log(Level.WARNING, message);
            throw new MLSException("FileService.IOError", message);
        }
        if (!FileUtils.isValidFileName(filename)) {
            String message = "Invalid file name: " + normalizedFileName;
            logger.log(Level.WARNING, message);
            throw new MLSException("FileService.IOError", message);
        }
    }

    private boolean normalizedFileNameNeedsConversion(String normalizedFileName) {
        return normalizedFileName != null && !normalizedFileName.matches("\\.\\.");
    }

    @Override
    public boolean filenameNeedsConversion(String fileName) {
        String normalizedFileName = FilenameUtils.normalize(fileName);
        return this.normalizedFileNameNeedsConversion(normalizedFileName);
    }

    @Override
    public String getWorkerMountPoint() {
        return this.workerMountPoint;
    }

    @Override
    public String getWorkerMountPoint(UserTokenDO userToken) {
        String mountPoint = this.getWorkerMountPoint();
        if (!mountPoint.endsWith(this.getWorkerFileSeparator())) {
            mountPoint = mountPoint + this.getWorkerFileSeparator();
        }
        return mountPoint + userToken.getName();
    }

    @Override
    public String getServerMountPoint() {
        return this.serverMountPoint;
    }

    @Override
    public String getServerMountPoint(UserTokenDO userToken) {
        String mountPoint = this.getServerMountPoint();
        if (!mountPoint.endsWith(this.getServerFileSeparator())) {
            mountPoint = mountPoint + this.getServerFileSeparator();
        }
        return mountPoint + userToken.getName();
    }

    @Override
    public String getWorkerFileSeparator() {
        return this.workerFileSeparator;
    }

    @Override
    public String getServerFileSeparator() {
        return this.serverFileSeparator;
    }

    public void setAdminId(String adminId) {
        this.adminId = adminId;
    }

    @Override
    public boolean folderCanMove(String source, String currentFolder) {
        return true;
    }
}

