/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.entitledproducts;

import com.mathworks.matlabserver.internalservices.client.ClientTypeRequestMessageDO;
import com.mathworks.matlabserver.internalservices.entitledproducts.EntitlementContext;
import java.io.Serializable;

public class AuthorizationContextTypeDO
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CONTEXT_TYPE_MOTW = "MOTW";
    public static final String CONTEXT_TYPE_ML_MOBILE = "ML_MOBILE";
    private final String contextType;

    public static AuthorizationContextTypeDO getMOTWContext(boolean isMHLMContext) {
        return isMHLMContext ? new AuthorizationContextTypeDO(EntitlementContext.WEB.getLabel()) : new AuthorizationContextTypeDO(CONTEXT_TYPE_MOTW);
    }

    public static AuthorizationContextTypeDO getMobileContext(boolean isMHLMContext) {
        return isMHLMContext ? new AuthorizationContextTypeDO(EntitlementContext.MOBILE.getLabel()) : new AuthorizationContextTypeDO(CONTEXT_TYPE_ML_MOBILE);
    }

    public AuthorizationContextTypeDO(ClientTypeRequestMessageDO clientTypeRequest, boolean isMHLMContext) {
        this.contextType = isMHLMContext ? EntitlementContext.getContextForClientType(clientTypeRequest).getLabel() : (clientTypeRequest != null && (clientTypeRequest.isMobile() || clientTypeRequest.isUpload()) ? CONTEXT_TYPE_ML_MOBILE : CONTEXT_TYPE_MOTW);
    }

    private AuthorizationContextTypeDO(String contextType) {
        this.contextType = contextType;
    }

    public String getContext() {
        return this.contextType;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AuthorizationContextTypeDO that = (AuthorizationContextTypeDO)o2;
        return !(this.contextType != null ? !this.contextType.equals(that.contextType) : that.contextType != null);
    }

    public int hashCode() {
        return this.contextType != null ? this.contextType.hashCode() : 0;
    }

    public String toString() {
        return "AuthorizationContextTypeDO{contextType='" + this.contextType + '\'' + '}';
    }
}

