/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mathworks.matlabserver.internalservices.message.MLSResponseMessage;
import com.mathworks.matlabserver.jsonconverter.ClassLookupService;
import java.util.Collection;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLookupServiceImpl
implements ClassLookupService {
    private static final String PROPERTY_FILE = "message-indentifier-map";
    private static final Logger logger = Logger.getLogger(ClassLookupServiceImpl.class.getName());
    private final BiMap<String, Class> responseIdClassMap = HashBiMap.create();
    private final BiMap<String, Class> requestIdClassMap = HashBiMap.create();

    public ClassLookupServiceImpl() {
        this.loadMapping();
    }

    @Override
    public Collection<Class> getRequestClasses() {
        return this.requestIdClassMap.values();
    }

    @Override
    public Collection<Class> getResponseClasses() {
        return this.responseIdClassMap.values();
    }

    @Override
    public String getIdFromClass(Class theClass) {
        String id = (String)this.responseIdClassMap.inverse().get(theClass);
        if (id == null) {
            id = (String)this.requestIdClassMap.inverse().get(theClass);
        }
        if (id == null) {
            logger.warning("Unsupported class: " + theClass);
        }
        return id;
    }

    @Override
    public Class getClassForId(String id) {
        Class retval = (Class)this.requestIdClassMap.get(id);
        if (retval == null) {
            retval = (Class)this.responseIdClassMap.get(id);
        }
        if (retval == null) {
            logger.warning("Unsupported identifier: " + id);
        }
        return retval;
    }

    private void loadMapping() {
        ResourceBundle bundle = null;
        try {
            bundle = PropertyResourceBundle.getBundle(PROPERTY_FILE);
        }
        catch (MissingResourceException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
        if (bundle != null) {
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = bundle.getString(key);
                Class theClass = this.getClassQuietly(value);
                if (theClass == null) continue;
                if (MLSResponseMessage.class.isAssignableFrom(theClass)) {
                    this.responseIdClassMap.put(key, theClass);
                    continue;
                }
                this.requestIdClassMap.put(key, theClass);
            }
        }
    }

    private Class getClassQuietly(String className) {
        Class<?> theClass = null;
        try {
            theClass = Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            logger.severe("Not found " + e2.getMessage());
        }
        return theClass;
    }
}

