/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.eval;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mathworks.matlabserver.internalservices.eval.EvalRequestMessageDO;
import java.lang.reflect.Type;

public class EvalConverter
implements JsonDeserializer {
    private static final String HEIGHT_FIELD = "height";
    private static final String WIDTH_FIELD = "width";
    private static final String UUID_FIELD = "uuid";
    private static final String MCODE_FIELD = "mcode";

    public EvalRequestMessageDO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonMessage = jsonElement.getAsJsonObject();
        EvalRequestMessageDO message = new EvalRequestMessageDO();
        if (type == EvalRequestMessageDO.class) {
            if (jsonMessage.has(MCODE_FIELD)) {
                boolean isJsonNull = jsonMessage.get(MCODE_FIELD).isJsonNull();
                String mCodeString = isJsonNull ? jsonMessage.get(MCODE_FIELD).toString() : jsonMessage.get(MCODE_FIELD).getAsString();
                message.setMcode(mCodeString);
            }
            if (jsonMessage.has(HEIGHT_FIELD)) {
                message.setHeight(this.getIntegerFromJsonElementDouble(jsonMessage.get(HEIGHT_FIELD)));
            }
            if (jsonMessage.has(WIDTH_FIELD)) {
                message.setWidth(this.getIntegerFromJsonElementDouble(jsonMessage.get(WIDTH_FIELD)));
            }
            if (jsonMessage.has(UUID_FIELD)) {
                JsonElement element = jsonMessage.get(UUID_FIELD);
                message.setUuid(element.isJsonNull() ? "" : element.getAsString());
            }
        }
        return message;
    }

    private int getIntegerFromJsonElementDouble(JsonElement jsonElement) {
        int retVal;
        try {
            Double value = jsonElement.getAsDouble();
            retVal = (int)Math.abs(value);
        }
        catch (NumberFormatException e2) {
            retVal = Integer.MIN_VALUE;
        }
        return retVal;
    }
}

