/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.message;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mathworks.matlabserver.internalservices.message.MLSMessage;
import com.mathworks.matlabserver.jsonconverter.ClassLookupService;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapConverter
implements JsonDeserializer {
    private ClassLookupService classLookupService;

    public MapConverter(ClassLookupService classLookupService) {
        this.classLookupService = classLookupService;
    }

    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        HashMap<String, MLSMessage[]> retval = new HashMap<String, MLSMessage[]>();
        JsonObject object = jsonElement.getAsJsonObject();
        Set<Map.Entry<String, JsonElement>> set = object.entrySet();
        for (Map.Entry<String, JsonElement> mapEntry : set) {
            String name = mapEntry.getKey();
            JsonElement value = mapEntry.getValue();
            MLSMessage[] messageArray = null;
            Class theClass = this.classLookupService.getClassForId(name);
            Class<?> arrayClass = Array.newInstance(theClass, 0).getClass();
            if (theClass != null) {
                messageArray = (MLSMessage[])jsonDeserializationContext.deserialize(value, arrayClass);
            }
            retval.put(name, messageArray);
        }
        return retval;
    }
}

