/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.variableeditor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.variableeditor.VariableContentDO;
import com.mathworks.matlabserver.jsonconverter.impl.util.SpecialDoubleValuesSerializer;
import java.lang.reflect.Type;
import org.apache.commons.lang.StringUtils;

public class VariableContentConverter
implements JsonSerializer<VariableContentDO> {
    private static final String VALUES_FIELD = "values";
    private static final String READ_ONLY_TEXT_FIELD = "readOnlyText";
    private final Gson gson;

    public VariableContentConverter() {
        GsonBuilder builder = new GsonBuilder();
        builder.serializeSpecialFloatingPointValues();
        builder.registerTypeAdapter((Type)((Object)Double.class), new SpecialDoubleValuesSerializer());
        this.gson = builder.create();
    }

    @Override
    public JsonElement serialize(VariableContentDO src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonMap = new JsonObject();
        if (src.getValues() != null) {
            jsonMap.add(VALUES_FIELD, this.gson.toJsonTree(src.getValues()));
        }
        String readOnlyText = StringUtils.isNotEmpty(src.getReadOnlyText()) ? src.getReadOnlyText() : "";
        jsonMap.add(READ_ONLY_TEXT_FIELD, new JsonPrimitive(readOnlyText));
        return jsonMap;
    }
}

