/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.serviceregistry.impl;

import com.mathworks.matlabserver.internalservices.serviceendpoints.ServiceIdentifier;
import com.mathworks.matlabserver.internalservices.serviceendpoints.ServiceIdentifierEnum;
import com.mathworks.matlabserver.serviceregistry.ServiceRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class ServiceRegistryEnumImpl
implements ServiceRegistry {
    private final Logger logger = Logger.getLogger(ServiceRegistryEnumImpl.class.getName());
    private final ConcurrentHashMap<ServiceIdentifier, Map<String, String>> serviceRegistry = new ConcurrentHashMap();

    @Override
    public void registerService(ServiceIdentifier serviceIdentifier, Map<String, String> serviceProperties) {
        this.logger.info("Register " + serviceIdentifier + " , properties " + serviceProperties);
        if (serviceIdentifier == null) {
            throw new IllegalArgumentException("Service Identifier is not valid.");
        }
        this.serviceRegistry.put(serviceIdentifier, serviceProperties);
    }

    @Override
    public void removeService(ServiceIdentifier serviceIdentifier) {
        this.serviceRegistry.remove(serviceIdentifier);
    }

    @Override
    public Map<String, String> getService(ServiceIdentifier serviceIdentifier) throws IllegalArgumentException {
        if (serviceIdentifier == null) {
            throw new IllegalArgumentException("ServiceIdentifier is not a valid service name. Service name must be " + Arrays.toString(ServiceIdentifierEnum.values()));
        }
        return this.serviceRegistry.containsKey(serviceIdentifier) ? this.serviceRegistry.get(serviceIdentifier) : new HashMap<String, String>();
    }
}

