/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.service.breakpoint.impl13b.executionarrow;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.MFilePathUtil;
import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlwidgets.stack.StackInfoRegistry;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.text.mcode.MExecutionDisplayAdapter;
import java.io.File;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOCase;

public class MatlabExecutionDisplayAdapter
extends MExecutionDisplayAdapter {
    private File fFile;
    private DebugInterests fDebugObserver;

    public MatlabExecutionDisplayAdapter(Editor editor) {
        this(editor.getStorageLocation() != null ? ((FileStorageLocation)editor.getStorageLocation()).getFile() : null);
    }

    public MatlabExecutionDisplayAdapter(File file) {
        this.doBackingstoreInit(file);
    }

    private void doBackingstoreInit(File file) {
        if (file != null) {
            this.setFile(file);
            this.registerMatlabListeners();
        }
    }

    void setFile(File theFile) {
        this.fFile = theFile;
        this.setCurrentLine(-1);
        this.stackReply(StackInfoRegistry.getLastStackInfo());
        this.firePaintNeededEvent();
    }

    private void interestDebugStop(String filename, int lineNum) {
        if (this.fFile == null) {
            return;
        }
        String jPath = MFilePathUtil.mFileToSystemPathWithPFileMapping((String)filename);
        if (IOCase.SYSTEM.checkEquals(jPath, this.fFile.getPath())) {
            this.setCurrentLine(lineNum);
            if (this.getCurrentLine() < 0) {
                this.setCurrentLine(-this.getCurrentLine());
                this.setIsAfterLine(true);
            } else {
                this.setIsAfterLine(false);
            }
        } else {
            this.setCurrentLine(-1);
        }
        this.firePaintNeededEvent();
    }

    private void stackReply(MatlabDebugServices.StackInfo info) {
        if (info == null || this.fFile == null) {
            return;
        }
        this.getStackLines().clear();
        String absPath = MFilePathUtil.getFullPathname((String)this.fFile.getPath());
        File file1 = new File(absPath);
        int currentStack = info.getCurrentEntryIndex();
        String[] filenames = info.getFullFilenames();
        int[] linenumbers = info.getLineNumbers();
        for (int i2 = 0; i2 < filenames.length; ++i2) {
            String jPath = MFilePathUtil.mFileToSystemPathWithPFileMapping((String)filenames[i2]);
            File file2 = new File(jPath);
            if (!file1.equals(file2)) continue;
            if (currentStack == i2) {
                this.setCurrentLine(linenumbers[i2]);
                continue;
            }
            this.getStackLines().add(linenumbers[i2]);
        }
        this.firePaintNeededEvent();
    }

    private static synchronized void removeMatlabListeners(DebugInterests debugObserver) {
        if (debugObserver != null) {
            MatlabDebugServices.removeDefaultObserverListener((MatlabDebugObserver)debugObserver);
            StackInfoRegistry.removeListener((StackInfoRegistry.StackInfoChange)debugObserver);
        }
    }

    private void registerMatlabListeners() {
        if (Matlab.isMatlabAvailable() && this.fDebugObserver == null) {
            this.fDebugObserver = new DebugInterests();
            StackInfoRegistry.addListener((StackInfoRegistry.StackInfoChange)this.fDebugObserver);
            EditorStartup.addDebugObserver((MatlabDebugObserver)this.fDebugObserver);
            this.stackReply(StackInfoRegistry.getLastStackInfo());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fDebugObserver != null) {
            MatlabExecutionDisplayAdapter.removeMatlabListeners(this.fDebugObserver);
            this.fDebugObserver = null;
        }
    }

    private class DebugInterests
    extends MatlabDebugAdapter
    implements StackInfoRegistry.StackInfoChange {
        private DebugInterests() {
        }

        public void doDBStop(final String fileName, final int lineNo) {
            MatlabExecutionDisplayAdapter.this.setCurrentLine(-1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MatlabExecutionDisplayAdapter.this.interestDebugStop(fileName, lineNo + 1);
                }
            });
        }

        public void doDBCont() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MatlabExecutionDisplayAdapter.this.setCurrentLine(-1);
                    MatlabExecutionDisplayAdapter.this.getStackLines().clear();
                    MatlabExecutionDisplayAdapter.this.firePaintNeededEvent();
                }
            });
        }

        public void doDebugMode(boolean isDebugMode) {
            if (!isDebugMode) {
                this.doDBCont();
            }
        }

        public void doDbupDbdownChange(String filename, int lineNo) {
            MatlabExecutionDisplayAdapter.this.setCurrentLine(-1);
        }

        public void stackChanged(MatlabDebugServices.StackInfo info) {
            MatlabExecutionDisplayAdapter.this.stackReply(info);
        }
    }
}

