/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice.utils;

import com.objectplanet.image.PngEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class ImageSerializationUtils {
    public static String getDataUrlFromImage(BufferedImage image) {
        String buffer;
        String format = "png";
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            PngEncoder encoder = image.getType() == 2 || image.getType() == 6 ? new PngEncoder(6) : new PngEncoder(2);
            encoder.setCompression(1);
            encoder.encode(image, outputStream);
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            buffer = new String(Base64.encodeBase64((byte[])outputStream.toByteArray(), (boolean)false), "utf8");
        }
        catch (UnsupportedEncodingException ignore) {
            throw new IllegalStateException("Unable to use utf8!");
        }
        buffer = "data:image/" + format + ";base64," + buffer;
        return buffer;
    }

    public static BufferedImage getImageFromDataUrl(String dataUrl) {
        BufferedImage image = null;
        try {
            byte[] bytes = Base64.decodeBase64((byte[])dataUrl.substring(22).getBytes("utf8"));
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            image = ImageIO.read(input);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return image;
    }

    public static BufferedImage loadFileFromClasspath(String filename, int imageType) {
        BufferedImage origImage = ImageSerializationUtils.loadFileFromClasspath(filename);
        BufferedImage newImage = new BufferedImage(origImage.getWidth(), origImage.getHeight(), imageType);
        newImage.getGraphics().drawImage(origImage, 0, 0, null);
        return newImage;
    }

    public static BufferedImage loadFileFromClasspath(String filename) {
        try {
            ClassLoader classLoader = ImageSerializationUtils.class.getClassLoader();
            InputStream imageStream = classLoader.getResourceAsStream(filename);
            return ImageIO.read(imageStream);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load: " + filename);
        }
    }
}

