/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Vector;
import javax.mail.EventQueue;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.MailEvent;
import javax.mail.event.MessageChangedEvent;
import javax.mail.event.MessageChangedListener;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.search.SearchTerm;

public abstract class Folder {
    protected Store store;
    protected int mode = -1;
    public static final int HOLDS_MESSAGES = 1;
    public static final int HOLDS_FOLDERS = 2;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    private volatile Vector connectionListeners = null;
    private volatile Vector folderListeners = null;
    private volatile Vector messageCountListeners = null;
    private volatile Vector messageChangedListeners = null;
    private EventQueue q;
    private Object qLock = new Object();

    protected Folder(Store store) {
        this.store = store;
    }

    public abstract String getName();

    public abstract String getFullName();

    public URLName getURLName() throws MessagingException {
        URLName storeURL = this.getStore().getURLName();
        String fullname = this.getFullName();
        StringBuffer encodedName = new StringBuffer();
        char separator = this.getSeparator();
        if (fullname != null) {
            encodedName.append(fullname);
        }
        return new URLName(storeURL.getProtocol(), storeURL.getHost(), storeURL.getPort(), encodedName.toString(), storeURL.getUsername(), null);
    }

    public Store getStore() {
        return this.store;
    }

    public abstract Folder getParent() throws MessagingException;

    public abstract boolean exists() throws MessagingException;

    public abstract Folder[] list(String var1) throws MessagingException;

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        return this.list(pattern);
    }

    public Folder[] list() throws MessagingException {
        return this.list("%");
    }

    public Folder[] listSubscribed() throws MessagingException {
        return this.listSubscribed("%");
    }

    public abstract char getSeparator() throws MessagingException;

    public abstract int getType() throws MessagingException;

    public abstract boolean create(int var1) throws MessagingException;

    public boolean isSubscribed() {
        return true;
    }

    public void setSubscribed(boolean subscribe) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public abstract boolean hasNewMessages() throws MessagingException;

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract boolean delete(boolean var1) throws MessagingException;

    public abstract boolean renameTo(Folder var1) throws MessagingException;

    public abstract void open(int var1) throws MessagingException;

    public abstract void close(boolean var1) throws MessagingException;

    public abstract boolean isOpen();

    public int getMode() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Folder not open");
        }
        return this.mode;
    }

    public abstract Flags getPermanentFlags();

    public abstract int getMessageCount() throws MessagingException;

    public synchronized int getNewMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int newmsgs = 0;
        int total = this.getMessageCount();
        for (int i2 = 1; i2 <= total; ++i2) {
            try {
                if (!this.getMessage(i2).isSet(Flags.Flag.RECENT)) continue;
                ++newmsgs;
                continue;
            }
            catch (MessageRemovedException me) {
                // empty catch block
            }
        }
        return newmsgs;
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int unread = 0;
        int total = this.getMessageCount();
        for (int i2 = 1; i2 <= total; ++i2) {
            try {
                if (this.getMessage(i2).isSet(Flags.Flag.SEEN)) continue;
                ++unread;
                continue;
            }
            catch (MessageRemovedException me) {
                // empty catch block
            }
        }
        return unread;
    }

    public synchronized int getDeletedMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int deleted = 0;
        int total = this.getMessageCount();
        for (int i2 = 1; i2 <= total; ++i2) {
            try {
                if (!this.getMessage(i2).isSet(Flags.Flag.DELETED)) continue;
                ++deleted;
                continue;
            }
            catch (MessageRemovedException me) {
                // empty catch block
            }
        }
        return deleted;
    }

    public abstract Message getMessage(int var1) throws MessagingException;

    public synchronized Message[] getMessages(int start, int end) throws MessagingException {
        Message[] msgs = new Message[end - start + 1];
        for (int i2 = start; i2 <= end; ++i2) {
            msgs[i2 - start] = this.getMessage(i2);
        }
        return msgs;
    }

    public synchronized Message[] getMessages(int[] msgnums) throws MessagingException {
        int len = msgnums.length;
        Message[] msgs = new Message[len];
        for (int i2 = 0; i2 < len; ++i2) {
            msgs[i2] = this.getMessage(msgnums[i2]);
        }
        return msgs;
    }

    public synchronized Message[] getMessages() throws MessagingException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Folder not open");
        }
        int total = this.getMessageCount();
        Message[] msgs = new Message[total];
        for (int i2 = 1; i2 <= total; ++i2) {
            msgs[i2 - 1] = this.getMessage(i2);
        }
        return msgs;
    }

    public abstract void appendMessages(Message[] var1) throws MessagingException;

    public void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
    }

    public synchronized void setFlags(Message[] msgs, Flags flag, boolean value) throws MessagingException {
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            try {
                msgs[i2].setFlags(flag, value);
                continue;
            }
            catch (MessageRemovedException me) {
                // empty catch block
            }
        }
    }

    public synchronized void setFlags(int start, int end, Flags flag, boolean value) throws MessagingException {
        for (int i2 = start; i2 <= end; ++i2) {
            try {
                Message msg = this.getMessage(i2);
                msg.setFlags(flag, value);
                continue;
            }
            catch (MessageRemovedException me) {
                // empty catch block
            }
        }
    }

    public synchronized void setFlags(int[] msgnums, Flags flag, boolean value) throws MessagingException {
        for (int i2 = 0; i2 < msgnums.length; ++i2) {
            try {
                Message msg = this.getMessage(msgnums[i2]);
                msg.setFlags(flag, value);
                continue;
            }
            catch (MessageRemovedException me) {
                // empty catch block
            }
        }
    }

    public void copyMessages(Message[] msgs, Folder folder) throws MessagingException {
        if (!folder.exists()) {
            throw new FolderNotFoundException(folder.getFullName() + " does not exist", folder);
        }
        folder.appendMessages(msgs);
    }

    public abstract Message[] expunge() throws MessagingException;

    public Message[] search(SearchTerm term) throws MessagingException {
        return this.search(term, this.getMessages());
    }

    public Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        Vector<Message> matchedMsgs = new Vector<Message>();
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            try {
                if (!msgs[i2].match(term)) continue;
                matchedMsgs.addElement(msgs[i2]);
                continue;
            }
            catch (MessageRemovedException mrex) {
                // empty catch block
            }
        }
        Object[] m2 = new Message[matchedMsgs.size()];
        matchedMsgs.copyInto(m2);
        return m2;
    }

    public synchronized void addConnectionListener(ConnectionListener l2) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new Vector();
        }
        this.connectionListeners.addElement(l2);
    }

    public synchronized void removeConnectionListener(ConnectionListener l2) {
        if (this.connectionListeners != null) {
            this.connectionListeners.removeElement(l2);
        }
    }

    protected void notifyConnectionListeners(int type) {
        if (this.connectionListeners != null) {
            ConnectionEvent e2 = new ConnectionEvent(this, type);
            this.queueEvent(e2, this.connectionListeners);
        }
        if (type == 3) {
            this.terminateQueue();
        }
    }

    public synchronized void addFolderListener(FolderListener l2) {
        if (this.folderListeners == null) {
            this.folderListeners = new Vector();
        }
        this.folderListeners.addElement(l2);
    }

    public synchronized void removeFolderListener(FolderListener l2) {
        if (this.folderListeners != null) {
            this.folderListeners.removeElement(l2);
        }
    }

    protected void notifyFolderListeners(int type) {
        if (this.folderListeners != null) {
            FolderEvent e2 = new FolderEvent(this, this, type);
            this.queueEvent(e2, this.folderListeners);
        }
        this.store.notifyFolderListeners(type, this);
    }

    protected void notifyFolderRenamedListeners(Folder folder) {
        if (this.folderListeners != null) {
            FolderEvent e2 = new FolderEvent(this, this, folder, 3);
            this.queueEvent(e2, this.folderListeners);
        }
        this.store.notifyFolderRenamedListeners(this, folder);
    }

    public synchronized void addMessageCountListener(MessageCountListener l2) {
        if (this.messageCountListeners == null) {
            this.messageCountListeners = new Vector();
        }
        this.messageCountListeners.addElement(l2);
    }

    public synchronized void removeMessageCountListener(MessageCountListener l2) {
        if (this.messageCountListeners != null) {
            this.messageCountListeners.removeElement(l2);
        }
    }

    protected void notifyMessageAddedListeners(Message[] msgs) {
        if (this.messageCountListeners == null) {
            return;
        }
        MessageCountEvent e2 = new MessageCountEvent(this, 1, false, msgs);
        this.queueEvent(e2, this.messageCountListeners);
    }

    protected void notifyMessageRemovedListeners(boolean removed, Message[] msgs) {
        if (this.messageCountListeners == null) {
            return;
        }
        MessageCountEvent e2 = new MessageCountEvent(this, 2, removed, msgs);
        this.queueEvent(e2, this.messageCountListeners);
    }

    public synchronized void addMessageChangedListener(MessageChangedListener l2) {
        if (this.messageChangedListeners == null) {
            this.messageChangedListeners = new Vector();
        }
        this.messageChangedListeners.addElement(l2);
    }

    public synchronized void removeMessageChangedListener(MessageChangedListener l2) {
        if (this.messageChangedListeners != null) {
            this.messageChangedListeners.removeElement(l2);
        }
    }

    protected void notifyMessageChangedListeners(int type, Message msg) {
        if (this.messageChangedListeners == null) {
            return;
        }
        MessageChangedEvent e2 = new MessageChangedEvent(this, type, msg);
        this.queueEvent(e2, this.messageChangedListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEvent(MailEvent event, Vector vector) {
        Object object = this.qLock;
        synchronized (object) {
            if (this.q == null) {
                this.q = new EventQueue();
            }
        }
        Vector v = (Vector)vector.clone();
        this.q.enqueue(event, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateQueue() {
        Object object = this.qLock;
        synchronized (object) {
            if (this.q != null) {
                Vector dummyListeners = new Vector();
                dummyListeners.setSize(1);
                this.q.enqueue(new TerminatorEvent(), dummyListeners);
                this.q = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.terminateQueue();
    }

    public String toString() {
        String s = this.getFullName();
        if (s != null) {
            return s;
        }
        return super.toString();
    }

    static class TerminatorEvent
    extends MailEvent {
        private static final long serialVersionUID = 3765761925441296565L;

        TerminatorEvent() {
            super(new Object());
        }

        public void dispatch(Object listener) {
            Thread.currentThread().interrupt();
        }
    }
}

