/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;

public class ZipArchiveOutputStream
extends ArchiveOutputStream {
    static final int BYTE_MASK = 255;
    private static final int SHORT = 2;
    private static final int WORD = 4;
    static final int BUFFER_SIZE = 512;
    protected boolean finished = false;
    private static final int DEFLATER_BLOCK_SIZE = 8192;
    public static final int DEFLATED = 8;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int STORED = 0;
    static final String DEFAULT_ENCODING = "UTF8";
    public static final int EFS_FLAG = 2048;
    private ZipArchiveEntry entry;
    private String comment = "";
    private int level = -1;
    private boolean hasCompressionLevelChanged = false;
    private int method = 8;
    private final List entries = new LinkedList();
    private final CRC32 crc = new CRC32();
    private long written = 0L;
    private long dataStart = 0L;
    private long localDataStart = 0L;
    private long cdOffset = 0L;
    private long cdLength = 0L;
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private final Map offsets = new HashMap();
    private String encoding = "UTF8";
    private ZipEncoding zipEncoding = ZipEncodingHelper.getZipEncoding("UTF8");
    protected final Deflater def = new Deflater(this.level, true);
    private final byte[] buf = new byte[512];
    private final RandomAccessFile raf;
    private final OutputStream out;
    private boolean useUTF8Flag = true;
    private boolean fallbackToUTF8 = false;
    private UnicodeExtraFieldPolicy createUnicodeExtraFields = UnicodeExtraFieldPolicy.NEVER;
    static final byte[] LFH_SIG = ZipLong.LFH_SIG.getBytes();
    static final byte[] DD_SIG = ZipLong.DD_SIG.getBytes();
    static final byte[] CFH_SIG = ZipLong.CFH_SIG.getBytes();
    static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);

    public ZipArchiveOutputStream(OutputStream out) {
        this.out = out;
        this.raf = null;
    }

    public ZipArchiveOutputStream(File file) throws IOException {
        FileOutputStream o2 = null;
        RandomAccessFile _raf = null;
        try {
            _raf = new RandomAccessFile(file, "rw");
            _raf.setLength(0L);
        }
        catch (IOException e2) {
            if (_raf != null) {
                try {
                    _raf.close();
                }
                catch (IOException inner) {
                    // empty catch block
                }
                _raf = null;
            }
            o2 = new FileOutputStream(file);
        }
        this.out = o2;
        this.raf = _raf;
    }

    public boolean isSeekable() {
        return this.raf != null;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(encoding);
        this.useUTF8Flag &= ZipEncodingHelper.isUTF8(encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUseLanguageEncodingFlag(boolean b2) {
        this.useUTF8Flag = b2 && ZipEncodingHelper.isUTF8(this.encoding);
    }

    public void setCreateUnicodeExtraFields(UnicodeExtraFieldPolicy b2) {
        this.createUnicodeExtraFields = b2;
    }

    public void setFallbackToUTF8(boolean b2) {
        this.fallbackToUTF8 = b2;
    }

    public void finish() throws IOException {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.entry != null) {
            throw new IOException("This archives contains unclosed entries.");
        }
        this.cdOffset = this.written;
        Iterator i2 = this.entries.iterator();
        while (i2.hasNext()) {
            this.writeCentralFileHeader((ZipArchiveEntry)i2.next());
        }
        this.cdLength = this.written - this.cdOffset;
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.clear();
        this.finished = true;
    }

    public void closeArchiveEntry() throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry == null) {
            throw new IOException("No current entry to close");
        }
        long realCrc = this.crc.getValue();
        this.crc.reset();
        if (this.entry.getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.entry.setSize(ZipUtil.adjustToLong(this.def.getTotalIn()));
            this.entry.setCompressedSize(ZipUtil.adjustToLong(this.def.getTotalOut()));
            this.entry.setCrc(realCrc);
            this.def.reset();
            this.written += this.entry.getCompressedSize();
        } else if (this.raf == null) {
            if (this.entry.getCrc() != realCrc) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.getName() + ": " + Long.toHexString(this.entry.getCrc()) + " instead of " + Long.toHexString(realCrc));
            }
            if (this.entry.getSize() != this.written - this.dataStart) {
                throw new ZipException("bad size for entry " + this.entry.getName() + ": " + this.entry.getSize() + " instead of " + (this.written - this.dataStart));
            }
        } else {
            long size = this.written - this.dataStart;
            this.entry.setSize(size);
            this.entry.setCompressedSize(size);
            this.entry.setCrc(realCrc);
        }
        if (this.raf != null) {
            long save = this.raf.getFilePointer();
            this.raf.seek(this.localDataStart);
            this.writeOut(ZipLong.getBytes(this.entry.getCrc()));
            this.writeOut(ZipLong.getBytes(this.entry.getCompressedSize()));
            this.writeOut(ZipLong.getBytes(this.entry.getSize()));
            this.raf.seek(save);
        }
        this.writeDataDescriptor(this.entry);
        this.entry = null;
    }

    public void putArchiveEntry(ArchiveEntry archiveEntry) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry != null) {
            this.closeArchiveEntry();
        }
        this.entry = (ZipArchiveEntry)archiveEntry;
        this.entries.add(this.entry);
        if (this.entry.getMethod() == -1) {
            this.entry.setMethod(this.method);
        }
        if (this.entry.getTime() == -1L) {
            this.entry.setTime(System.currentTimeMillis());
        }
        if (this.entry.getMethod() == 0 && this.raf == null) {
            if (this.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.setCompressedSize(this.entry.getSize());
        }
        if (this.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader(this.entry);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + level);
        }
        this.hasCompressionLevelChanged = this.level != level;
        this.level = level;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public boolean canWriteEntryData(ArchiveEntry ae) {
        if (ae instanceof ZipArchiveEntry) {
            return ZipUtil.canHandleEntryData((ZipArchiveEntry)ae);
        }
        return false;
    }

    public void write(byte[] b2, int offset, int length) throws IOException {
        ZipUtil.checkRequestedFeatures(this.entry);
        if (this.entry.getMethod() == 8) {
            if (length > 0 && !this.def.finished()) {
                if (length <= 8192) {
                    this.def.setInput(b2, offset, length);
                    this.deflateUntilInputIsNeeded();
                } else {
                    int fullblocks = length / 8192;
                    for (int i2 = 0; i2 < fullblocks; ++i2) {
                        this.def.setInput(b2, offset + i2 * 8192, 8192);
                        this.deflateUntilInputIsNeeded();
                    }
                    int done = fullblocks * 8192;
                    if (done < length) {
                        this.def.setInput(b2, offset + done, length - done);
                        this.deflateUntilInputIsNeeded();
                    }
                }
            }
        } else {
            this.writeOut(b2, offset, length);
            this.written += (long)length;
        }
        this.crc.update(b2, offset, length);
        this.count(length);
    }

    public void close() throws IOException {
        if (!this.finished) {
            this.finish();
        }
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        int len = this.def.deflate(this.buf, 0, this.buf.length);
        if (len > 0) {
            this.writeOut(this.buf, 0, len);
        }
    }

    protected void writeLocalFileHeader(ZipArchiveEntry ze) throws IOException {
        boolean encodable = this.zipEncoding.canEncode(ze.getName());
        ZipEncoding entryEncoding = !encodable && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        ByteBuffer name = entryEncoding.encode(ze.getName());
        if (this.createUnicodeExtraFields != UnicodeExtraFieldPolicy.NEVER) {
            String comm;
            if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !encodable) {
                ze.addExtraField(new UnicodePathExtraField(ze.getName(), name.array(), name.arrayOffset(), name.limit()));
            }
            if ((comm = ze.getComment()) != null && !"".equals(comm)) {
                boolean commentEncodable = this.zipEncoding.canEncode(comm);
                if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !commentEncodable) {
                    ByteBuffer commentB = entryEncoding.encode(comm);
                    ze.addExtraField(new UnicodeCommentExtraField(comm, commentB.array(), commentB.arrayOffset(), commentB.limit()));
                }
            }
        }
        this.offsets.put(ze, ZipLong.getBytes(this.written));
        this.writeOut(LFH_SIG);
        this.written += 4L;
        int zipMethod = ze.getMethod();
        this.writeVersionNeededToExtractAndGeneralPurposeBits(zipMethod, !encodable && this.fallbackToUTF8);
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(zipMethod));
        this.written += 2L;
        this.writeOut(ZipUtil.toDosTime(ze.getTime()));
        this.written += 4L;
        this.localDataStart = this.written;
        if (zipMethod == 8 || this.raf != null) {
            this.writeOut(LZERO);
            this.writeOut(LZERO);
            this.writeOut(LZERO);
        } else {
            this.writeOut(ZipLong.getBytes(ze.getCrc()));
            this.writeOut(ZipLong.getBytes(ze.getSize()));
            this.writeOut(ZipLong.getBytes(ze.getSize()));
        }
        this.written += 12L;
        this.writeOut(ZipShort.getBytes(name.limit()));
        this.written += 2L;
        byte[] extra = ze.getLocalFileDataExtra();
        this.writeOut(ZipShort.getBytes(extra.length));
        this.written += 2L;
        this.writeOut(name.array(), name.arrayOffset(), name.limit());
        this.written += (long)name.limit();
        this.writeOut(extra);
        this.written += (long)extra.length;
        this.dataStart = this.written;
    }

    protected void writeDataDescriptor(ZipArchiveEntry ze) throws IOException {
        if (ze.getMethod() != 8 || this.raf != null) {
            return;
        }
        this.writeOut(DD_SIG);
        this.writeOut(ZipLong.getBytes(this.entry.getCrc()));
        this.writeOut(ZipLong.getBytes(this.entry.getCompressedSize()));
        this.writeOut(ZipLong.getBytes(this.entry.getSize()));
        this.written += 16L;
    }

    protected void writeCentralFileHeader(ZipArchiveEntry ze) throws IOException {
        this.writeOut(CFH_SIG);
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(ze.getPlatform() << 8 | 0x14));
        this.written += 2L;
        int zipMethod = ze.getMethod();
        boolean encodable = this.zipEncoding.canEncode(ze.getName());
        this.writeVersionNeededToExtractAndGeneralPurposeBits(zipMethod, !encodable && this.fallbackToUTF8);
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(zipMethod));
        this.written += 2L;
        this.writeOut(ZipUtil.toDosTime(ze.getTime()));
        this.written += 4L;
        this.writeOut(ZipLong.getBytes(ze.getCrc()));
        this.writeOut(ZipLong.getBytes(ze.getCompressedSize()));
        this.writeOut(ZipLong.getBytes(ze.getSize()));
        this.written += 12L;
        ZipEncoding entryEncoding = !encodable && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        ByteBuffer name = entryEncoding.encode(ze.getName());
        this.writeOut(ZipShort.getBytes(name.limit()));
        this.written += 2L;
        byte[] extra = ze.getCentralDirectoryExtra();
        this.writeOut(ZipShort.getBytes(extra.length));
        this.written += 2L;
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        ByteBuffer commentB = entryEncoding.encode(comm);
        this.writeOut(ZipShort.getBytes(commentB.limit()));
        this.written += 2L;
        this.writeOut(ZERO);
        this.written += 2L;
        this.writeOut(ZipShort.getBytes(ze.getInternalAttributes()));
        this.written += 2L;
        this.writeOut(ZipLong.getBytes(ze.getExternalAttributes()));
        this.written += 4L;
        this.writeOut((byte[])this.offsets.get(ze));
        this.written += 4L;
        this.writeOut(name.array(), name.arrayOffset(), name.limit());
        this.written += (long)name.limit();
        this.writeOut(extra);
        this.written += (long)extra.length;
        this.writeOut(commentB.array(), commentB.arrayOffset(), commentB.limit());
        this.written += (long)commentB.limit();
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.writeOut(EOCD_SIG);
        this.writeOut(ZERO);
        this.writeOut(ZERO);
        byte[] num = ZipShort.getBytes(this.entries.size());
        this.writeOut(num);
        this.writeOut(num);
        this.writeOut(ZipLong.getBytes(this.cdLength));
        this.writeOut(ZipLong.getBytes(this.cdOffset));
        ByteBuffer data = this.zipEncoding.encode(this.comment);
        this.writeOut(ZipShort.getBytes(data.limit()));
        this.writeOut(data.array(), data.arrayOffset(), data.limit());
    }

    protected final void writeOut(byte[] data) throws IOException {
        this.writeOut(data, 0, data.length);
    }

    protected final void writeOut(byte[] data, int offset, int length) throws IOException {
        if (this.raf != null) {
            this.raf.write(data, offset, length);
        } else {
            this.out.write(data, offset, length);
        }
    }

    private void deflateUntilInputIsNeeded() throws IOException {
        while (!this.def.needsInput()) {
            this.deflate();
        }
    }

    private void writeVersionNeededToExtractAndGeneralPurposeBits(int zipMethod, boolean utfFallback) throws IOException {
        int versionNeededToExtract = 10;
        GeneralPurposeBit b2 = new GeneralPurposeBit();
        b2.useUTF8ForNames(this.useUTF8Flag || utfFallback);
        if (zipMethod == 8 && this.raf == null) {
            versionNeededToExtract = 20;
            b2.useDataDescriptor(true);
        }
        this.writeOut(ZipShort.getBytes(versionNeededToExtract));
        this.writeOut(b2.encode());
    }

    public ArchiveEntry createArchiveEntry(File inputFile, String entryName) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new ZipArchiveEntry(inputFile, entryName);
    }

    public static final class UnicodeExtraFieldPolicy {
        public static final UnicodeExtraFieldPolicy ALWAYS = new UnicodeExtraFieldPolicy("always");
        public static final UnicodeExtraFieldPolicy NEVER = new UnicodeExtraFieldPolicy("never");
        public static final UnicodeExtraFieldPolicy NOT_ENCODEABLE = new UnicodeExtraFieldPolicy("not encodeable");
        private final String name;

        private UnicodeExtraFieldPolicy(String n2) {
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }
}

