/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.ObjectPool;

public class PoolableConnection
extends DelegatingConnection {
    protected ObjectPool _pool = null;

    public PoolableConnection(Connection conn, ObjectPool pool) {
        super(conn);
        this._pool = pool;
    }

    public PoolableConnection(Connection conn, ObjectPool pool, AbandonedConfig config) {
        super(conn, config);
        this._pool = pool;
    }

    public synchronized void close() throws SQLException {
        boolean isClosed = false;
        try {
            isClosed = this.isClosed();
        }
        catch (SQLException e2) {
            try {
                this._pool.invalidateObject(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLNestedException("Cannot close connection (isClosed check failed)", e2);
        }
        if (isClosed) {
            try {
                this._pool.invalidateObject(this);
            }
            catch (Exception ie) {
                // empty catch block
            }
            throw new SQLException("Already closed.");
        }
        try {
            this._pool.returnObject(this);
        }
        catch (SQLException e3) {
            throw e3;
        }
        catch (RuntimeException e4) {
            throw e4;
        }
        catch (Exception e5) {
            throw new SQLNestedException("Cannot close connection (return to pool failed)", e5);
        }
    }

    public void reallyClose() throws SQLException {
        super.close();
    }
}

