/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPool;

public class PoolablePreparedStatement
extends DelegatingPreparedStatement
implements PreparedStatement {
    protected KeyedObjectPool _pool = null;
    protected Object _key = null;

    public PoolablePreparedStatement(PreparedStatement stmt, Object key, KeyedObjectPool pool, Connection conn) {
        super((DelegatingConnection)conn, stmt);
        this._pool = pool;
        this._key = key;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Already closed");
        }
        try {
            this._pool.returnObject(this._key, this);
        }
        catch (SQLException e2) {
            throw e2;
        }
        catch (RuntimeException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new SQLNestedException("Cannot close preparedstatement (return to pool failed)", e4);
        }
    }

    protected void activate() throws SQLException {
        this._closed = false;
        if (this._conn != null) {
            this._conn.addTrace(this);
        }
        super.activate();
    }

    protected void passivate() throws SQLException {
        List resultSets;
        this._closed = true;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
        if ((resultSets = this.getTrace()) != null) {
            ResultSet[] set = resultSets.toArray(new ResultSet[resultSets.size()]);
            for (int i2 = 0; i2 < set.length; ++i2) {
                set[i2].close();
            }
            this.clearTrace();
        }
        super.passivate();
    }
}

