/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.filter;

import java.lang.reflect.Array;
import java.util.regex.Pattern;
import org.cometd.server.filter.JSONDataFilter;

public class RegexFilter
extends JSONDataFilter {
    protected String[] _templates;
    protected String[] _replaces;
    protected transient Pattern[] _patterns;

    public void init(Object init) {
        super.init(init);
        this._templates = new String[Array.getLength(init)];
        this._replaces = new String[this._templates.length];
        for (int i2 = 0; i2 < this._templates.length; ++i2) {
            Object entry = Array.get(init, i2);
            this._templates[i2] = (String)Array.get(entry, 0);
            this._replaces[i2] = (String)Array.get(entry, 1);
        }
        this.checkPatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPatterns() {
        RegexFilter regexFilter = this;
        synchronized (regexFilter) {
            if (this._patterns == null) {
                this._patterns = new Pattern[this._templates.length];
                for (int i2 = 0; i2 < this._patterns.length; ++i2) {
                    this._patterns[i2] = Pattern.compile(this._templates[i2]);
                }
            }
        }
    }

    protected Object filterString(String string) {
        this.checkPatterns();
        for (int i2 = 0; i2 < this._patterns.length; ++i2) {
            if (this._replaces[i2] != null) {
                string = this._patterns[i2].matcher(string).replaceAll(this._replaces[i2]);
                continue;
            }
            if (!this._patterns[i2].matcher(string).matches()) continue;
            throw new IllegalStateException("matched " + this._patterns[i2] + " in " + string);
        }
        return string;
    }
}

