/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.StringUtil;

public class BufferUtil {
    static final byte SPACE = 32;
    static final byte MINUS = 45;
    static final byte[] DIGIT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int[] decDivisors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final int[] hexDivisors = new int[]{0x10000000, 0x1000000, 0x100000, 65536, 4096, 256, 16, 1};
    private static final long[] decDivisorsL = new long[]{1000000000000000000L, 100000000000000000L, 10000000000000000L, 1000000000000000L, 100000000000000L, 10000000000000L, 1000000000000L, 100000000000L, 10000000000L, 1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};

    public static int toInt(Buffer buffer) {
        int val = 0;
        boolean started = false;
        boolean minus = false;
        for (int i2 = buffer.getIndex(); i2 < buffer.putIndex(); ++i2) {
            byte b2 = buffer.peek(i2);
            if (b2 <= 32) {
                if (!started) continue;
                break;
            }
            if (b2 >= 48 && b2 <= 57) {
                val = val * 10 + (b2 - 48);
                started = true;
                continue;
            }
            if (b2 != 45 || started) break;
            minus = true;
        }
        if (started) {
            return minus ? -val : val;
        }
        throw new NumberFormatException(buffer.toString());
    }

    public static long toLong(Buffer buffer) {
        long val = 0L;
        boolean started = false;
        boolean minus = false;
        for (int i2 = buffer.getIndex(); i2 < buffer.putIndex(); ++i2) {
            byte b2 = buffer.peek(i2);
            if (b2 <= 32) {
                if (!started) continue;
                break;
            }
            if (b2 >= 48 && b2 <= 57) {
                val = val * 10L + (long)(b2 - 48);
                started = true;
                continue;
            }
            if (b2 != 45 || started) break;
            minus = true;
        }
        if (started) {
            return minus ? -val : val;
        }
        throw new NumberFormatException(buffer.toString());
    }

    public static void putHexInt(Buffer buffer, int n2) {
        if (n2 < 0) {
            buffer.put((byte)45);
            if (n2 == Integer.MIN_VALUE) {
                buffer.put((byte)56);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                return;
            }
            n2 = -n2;
        }
        if (n2 < 16) {
            buffer.put(DIGIT[n2]);
        } else {
            boolean started = false;
            for (int i2 = 0; i2 < hexDivisors.length; ++i2) {
                if (n2 < hexDivisors[i2]) {
                    if (!started) continue;
                    buffer.put((byte)48);
                    continue;
                }
                started = true;
                int d2 = n2 / hexDivisors[i2];
                buffer.put(DIGIT[d2]);
                n2 -= d2 * hexDivisors[i2];
            }
        }
    }

    public static void prependHexInt(Buffer buffer, int n2) {
        if (n2 == 0) {
            int gi = buffer.getIndex();
            buffer.poke(--gi, (byte)48);
            buffer.setGetIndex(gi);
        } else {
            boolean minus = false;
            if (n2 < 0) {
                minus = true;
                n2 = -n2;
            }
            int gi = buffer.getIndex();
            while (n2 > 0) {
                int d2 = 0xF & n2;
                n2 >>= 4;
                buffer.poke(--gi, DIGIT[d2]);
            }
            if (minus) {
                buffer.poke(--gi, (byte)45);
            }
            buffer.setGetIndex(gi);
        }
    }

    public static void putDecInt(Buffer buffer, int n2) {
        if (n2 < 0) {
            buffer.put((byte)45);
            if (n2 == Integer.MIN_VALUE) {
                buffer.put((byte)50);
                n2 = 147483648;
            } else {
                n2 = -n2;
            }
        }
        if (n2 < 10) {
            buffer.put(DIGIT[n2]);
        } else {
            boolean started = false;
            for (int i2 = 0; i2 < decDivisors.length; ++i2) {
                if (n2 < decDivisors[i2]) {
                    if (!started) continue;
                    buffer.put((byte)48);
                    continue;
                }
                started = true;
                int d2 = n2 / decDivisors[i2];
                buffer.put(DIGIT[d2]);
                n2 -= d2 * decDivisors[i2];
            }
        }
    }

    public static void putDecLong(Buffer buffer, long n2) {
        if (n2 < 0L) {
            buffer.put((byte)45);
            if (n2 == Long.MIN_VALUE) {
                buffer.put((byte)57);
                n2 = 223372036854775808L;
            } else {
                n2 = -n2;
            }
        }
        if (n2 < 10L) {
            buffer.put(DIGIT[(int)n2]);
        } else {
            boolean started = false;
            for (int i2 = 0; i2 < decDivisorsL.length; ++i2) {
                if (n2 < decDivisorsL[i2]) {
                    if (!started) continue;
                    buffer.put((byte)48);
                    continue;
                }
                started = true;
                long d2 = n2 / decDivisorsL[i2];
                buffer.put(DIGIT[(int)d2]);
                n2 -= d2 * decDivisorsL[i2];
            }
        }
    }

    public static Buffer toBuffer(long value) {
        ByteArrayBuffer buf = new ByteArrayBuffer(32);
        BufferUtil.putDecLong(buf, value);
        return buf;
    }

    public static void putCRLF(Buffer buffer) {
        buffer.put((byte)13);
        buffer.put((byte)10);
    }

    public static boolean isPrefix(Buffer prefix, Buffer buffer) {
        if (prefix.length() > buffer.length()) {
            return false;
        }
        int bi = buffer.getIndex();
        for (int i2 = prefix.getIndex(); i2 < prefix.putIndex(); ++i2) {
            if (prefix.peek(i2) == buffer.peek(bi++)) continue;
            return false;
        }
        return true;
    }

    public static String to8859_1_String(Buffer buffer) {
        if (buffer instanceof BufferCache.CachedBuffer) {
            return buffer.toString();
        }
        return buffer.toString(StringUtil.__ISO_8859_1_CHARSET);
    }
}

