/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Container {
    private static final Logger LOG = Log.getLogger(Container.class);
    private final CopyOnWriteArrayList<Listener> _listeners = new CopyOnWriteArrayList();

    public void addEventListener(Listener listener) {
        this._listeners.add(listener);
    }

    public void removeEventListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public void update(Object parent, Object oldChild, Object child, String relationship) {
        if (oldChild != null && !oldChild.equals(child)) {
            this.remove(parent, oldChild, relationship);
        }
        if (child != null && !child.equals(oldChild)) {
            this.add(parent, child, relationship);
        }
    }

    public void update(Object parent, Object oldChild, Object child, String relationship, boolean addRemove) {
        if (oldChild != null && !oldChild.equals(child)) {
            this.remove(parent, oldChild, relationship);
            if (addRemove) {
                this.removeBean(oldChild);
            }
        }
        if (child != null && !child.equals(oldChild)) {
            if (addRemove) {
                this.addBean(child);
            }
            this.add(parent, child, relationship);
        }
    }

    public void update(Object parent, Object[] oldChildren, Object[] children, String relationship) {
        this.update(parent, oldChildren, children, relationship, false);
    }

    public void update(Object parent, Object[] oldChildren, Object[] children, String relationship, boolean addRemove) {
        int i2;
        Object[] newChildren = null;
        if (children != null) {
            newChildren = new Object[children.length];
            i2 = children.length;
            while (i2-- > 0) {
                boolean new_child = true;
                if (oldChildren != null) {
                    int j2 = oldChildren.length;
                    while (j2-- > 0) {
                        if (children[i2] == null || !children[i2].equals(oldChildren[j2])) continue;
                        oldChildren[j2] = null;
                        new_child = false;
                    }
                }
                if (!new_child) continue;
                newChildren[i2] = children[i2];
            }
        }
        if (oldChildren != null) {
            i2 = oldChildren.length;
            while (i2-- > 0) {
                if (oldChildren[i2] == null) continue;
                this.remove(parent, oldChildren[i2], relationship);
                if (!addRemove) continue;
                this.removeBean(oldChildren[i2]);
            }
        }
        if (newChildren != null) {
            for (i2 = 0; i2 < newChildren.length; ++i2) {
                if (newChildren[i2] == null) continue;
                if (addRemove) {
                    this.addBean(newChildren[i2]);
                }
                this.add(parent, newChildren[i2], relationship);
            }
        }
    }

    public void addBean(Object obj) {
        if (this._listeners != null) {
            for (int i2 = 0; i2 < LazyList.size(this._listeners); ++i2) {
                Listener listener = (Listener)LazyList.get(this._listeners, i2);
                listener.addBean(obj);
            }
        }
    }

    public void removeBean(Object obj) {
        if (this._listeners != null) {
            for (int i2 = 0; i2 < LazyList.size(this._listeners); ++i2) {
                ((Listener)LazyList.get(this._listeners, i2)).removeBean(obj);
            }
        }
    }

    private void add(Object parent, Object child, String relationship) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container " + parent + " + " + child + " as " + relationship, new Object[0]);
        }
        if (this._listeners != null) {
            Relationship event = new Relationship(this, parent, child, relationship);
            for (int i2 = 0; i2 < LazyList.size(this._listeners); ++i2) {
                ((Listener)LazyList.get(this._listeners, i2)).add(event);
            }
        }
    }

    private void remove(Object parent, Object child, String relationship) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container " + parent + " - " + child + " as " + relationship, new Object[0]);
        }
        if (this._listeners != null) {
            Relationship event = new Relationship(this, parent, child, relationship);
            for (int i2 = 0; i2 < LazyList.size(this._listeners); ++i2) {
                ((Listener)LazyList.get(this._listeners, i2)).remove(event);
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void addBean(Object var1);

        public void removeBean(Object var1);

        public void add(Relationship var1);

        public void remove(Relationship var1);
    }

    public static class Relationship {
        private final WeakReference<Object> _parent;
        private final WeakReference<Object> _child;
        private String _relationship;
        private Container _container;

        private Relationship(Container container, Object parent, Object child, String relationship) {
            this._container = container;
            this._parent = new WeakReference<Object>(parent);
            this._child = new WeakReference<Object>(child);
            this._relationship = relationship;
        }

        public Container getContainer() {
            return this._container;
        }

        public Object getChild() {
            return this._child.get();
        }

        public Object getParent() {
            return this._parent.get();
        }

        public String getRelationship() {
            return this._relationship;
        }

        public String toString() {
            return this._parent + "---" + this._relationship + "-->" + this._child;
        }

        public int hashCode() {
            return this._parent.hashCode() + this._child.hashCode() + this._relationship.hashCode();
        }

        public boolean equals(Object o2) {
            if (o2 == null || !(o2 instanceof Relationship)) {
                return false;
            }
            Relationship r = (Relationship)o2;
            return r._parent.get() == this._parent.get() && r._child.get() == this._child.get() && r._relationship.equals(this._relationship);
        }
    }
}

