/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.SearchField;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IndexDocument<T extends SearchField> {
    private float fBoost = 1.0f;
    private final Map<T, String> fIndexValues = new HashMap<T, String>();
    private final Map<T, Float> fFieldBoosts = new HashMap<T, Float>();

    public IndexDocument() {
    }

    public IndexDocument(Map<T, String> fieldValues) {
        this.fIndexValues.putAll(fieldValues);
    }

    public void addFieldValue(T field, String value) {
        this.fIndexValues.put(field, value);
    }

    public Map<T, String> getIndexValues() {
        return Collections.unmodifiableMap(this.fIndexValues);
    }

    public void setBoost(float boost) {
        this.fBoost = boost;
    }

    public void setFieldBoost(T field, float boost) {
        this.fFieldBoosts.put(field, Float.valueOf(boost));
    }

    public void setFieldBoosts(Map<T, Float> boosts) {
        this.fFieldBoosts.putAll(boosts);
    }

    public float getFieldBoost(T field) {
        if (this.fFieldBoosts.containsKey(field)) {
            return this.fFieldBoosts.get(field).floatValue();
        }
        return 1.0f;
    }

    public float getBoost() {
        return this.fBoost;
    }
}

