/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchHighlight {
    private final String fOriginalText;
    private final String fHighlightText;
    private final List<Extent> fExtents = new ArrayList<Extent>();

    public SearchHighlight(String highlightText) {
        this.fOriginalText = highlightText;
        this.fHighlightText = highlightText.replaceAll("\\n", " ");
    }

    public void addExtent(int start, int end) {
        this.fExtents.add(new Extent(start, end));
    }

    public String getHighlightText() {
        return this.fHighlightText;
    }

    public String getOriginalText() {
        return this.fOriginalText;
    }

    public List<Extent> getExtents() {
        return Collections.unmodifiableList(this.fExtents);
    }

    public String toString() {
        return this.toString("[", "]");
    }

    public String toString(String beforeExtent, String afterExtent) {
        StringBuilder out = new StringBuilder();
        int index = 0;
        for (Extent extent : this.fExtents) {
            out.append(this.fHighlightText.substring(index, extent.getStart()));
            out.append(beforeExtent);
            out.append(this.fHighlightText.substring(extent.getStart(), extent.getEnd()));
            out.append(afterExtent);
            index = extent.getEnd();
        }
        out.append(this.fHighlightText.substring(index));
        return out.toString();
    }

    public class Extent {
        private int iStart;
        private int iEnd;

        public Extent(int start, int end) {
            this.iStart = start;
            this.iEnd = end;
        }

        public int getStart() {
            return this.iStart;
        }

        public int getEnd() {
            return this.iEnd;
        }

        public String getText() {
            return SearchHighlight.this.getHighlightText().substring(this.getStart(), this.getEnd());
        }

        public String toString() {
            return "[" + this.iStart + " : " + this.iEnd + "]";
        }
    }
}

