/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.HighlightProvider;
import com.mathworks.search.SearchHighlight;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextHighlighter {
    private final Pattern fKeywordsPattern;

    public TextHighlighter(String ... keywords) {
        this(Arrays.asList(keywords));
    }

    public TextHighlighter(Collection<String> keywords) {
        this(HighlightRule.FULL_WORD, keywords);
    }

    public TextHighlighter(HighlightRule rule, String ... keywords) {
        this(rule, Arrays.asList(keywords));
    }

    public TextHighlighter(HighlightRule rule, Collection<String> keywords) {
        this.fKeywordsPattern = TextHighlighter.createPatternForKeywords(rule, keywords);
    }

    private static Pattern createPatternForKeywords(HighlightRule rule, Collection<String> keywords) {
        switch (rule) {
            case PREFIX: {
                return Pattern.compile("\\b" + TextHighlighter.buildOrPattern(keywords), 2);
            }
            case ANY_MATCH: {
                return Pattern.compile(TextHighlighter.buildOrPattern(keywords), 2);
            }
        }
        String looseRegexp = HighlightProvider.createKeywordsRegexp(keywords, true);
        return Pattern.compile(looseRegexp, 2);
    }

    private static String buildOrPattern(Collection<String> keywords) {
        StringBuilder words = new StringBuilder("(");
        for (String keyword : keywords) {
            words.append(Pattern.quote(keyword));
            words.append("|");
        }
        words.deleteCharAt(words.length() - 1);
        words.append(")");
        return words.toString();
    }

    public SearchHighlight addHighlightsToString(String highlightText) {
        SearchHighlight highlight = new SearchHighlight(highlightText);
        Matcher keywordsMatcher = this.fKeywordsPattern.matcher(highlightText);
        while (keywordsMatcher.find()) {
            if (keywordsMatcher.groupCount() <= 0) continue;
            highlight.addExtent(keywordsMatcher.start(1), keywordsMatcher.end(1));
        }
        return highlight;
    }

    public static SearchHighlight addHighlightsToString(String highlightText, String ... keywords) {
        return new TextHighlighter(keywords).addHighlightsToString(highlightText);
    }

    public static enum HighlightRule {
        FULL_WORD,
        PREFIX,
        ANY_MATCH;

    }
}

