/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.facet;

import com.mathworks.search.SearchResult;
import com.mathworks.search.facet.FacetFilter;
import com.mathworks.search.facet.FacetResult;
import com.mathworks.search.facet.FacetResultCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleFacetResultCollector<T>
implements FacetResultCollector<T> {
    private final FacetFilter<T> fFilter;
    private final Map<T, FacetResult<T>> fResults = new HashMap<T, FacetResult<T>>();
    private final Comparator<FacetResult<T>> fComparator;
    private List<FacetResult<T>> fListResults = null;

    private SimpleFacetResultCollector(FacetFilter<T> filter, Comparator<FacetResult<T>> comparator) {
        this.fFilter = filter;
        this.fComparator = comparator;
    }

    public static <T extends Comparable<T>> SimpleFacetResultCollector<T> createCollector(FacetFilter<T> filter) {
        return new SimpleFacetResultCollector<T>(filter, new ComparableFacetResultComparator());
    }

    public static <T> SimpleFacetResultCollector<T> createFacetComparatorCollector(FacetFilter<T> filter, Comparator<? super T> comparator) {
        return new SimpleFacetResultCollector<T>(filter, new DefaultFacetResultComparator(comparator));
    }

    public static <T> SimpleFacetResultCollector<T> createResultComparatorCollector(FacetFilter<T> filter, Comparator<FacetResult<T>> comparator) {
        return new SimpleFacetResultCollector<T>(filter, comparator);
    }

    public static <T> SimpleFacetResultCollector<T> createSortByResultCountCollector(FacetFilter<T> filter) {
        return SimpleFacetResultCollector.createResultComparatorCollector(filter, new ResultCountComparator());
    }

    @Override
    public void examineResult(SearchResult result) {
        Collection<T> facets = this.fFilter.determineFacet(result);
        for (T facet : facets) {
            if (this.fResults.containsKey(facet)) {
                this.fResults.get(facet).increment();
                continue;
            }
            this.fResults.put(facet, new FacetResult<T>(facet));
        }
    }

    @Override
    public void resultsComplete() {
        this.fListResults = new ArrayList<FacetResult<T>>();
        this.fListResults.addAll(this.fResults.values());
        Collections.sort(this.fListResults, this.fComparator);
    }

    @Override
    public List<FacetResult<T>> getResults() {
        if (this.fListResults == null) {
            throw new IllegalStateException("Results not yet complete");
        }
        return Collections.unmodifiableList(this.fListResults);
    }

    private static class ResultCountComparator<T>
    implements Comparator<FacetResult<T>> {
        private ResultCountComparator() {
        }

        @Override
        public int compare(FacetResult<T> result1, FacetResult<T> result2) {
            return result2.getNumResults() - result1.getNumResults();
        }
    }

    private static class DefaultFacetResultComparator<T>
    implements Comparator<FacetResult<T>> {
        private final Comparator<? super T> iComparator;

        private DefaultFacetResultComparator(Comparator<? super T> comparator) {
            this.iComparator = comparator;
        }

        @Override
        public int compare(FacetResult<T> result1, FacetResult<T> result2) {
            return this.iComparator.compare(result1.getCategory(), result2.getCategory());
        }
    }

    private static class ComparableFacetResultComparator<T extends Comparable<T>>
    implements Comparator<FacetResult<T>> {
        private ComparableFacetResultComparator() {
        }

        @Override
        public int compare(FacetResult<T> result1, FacetResult<T> result2) {
            Comparable category1 = (Comparable)result1.getCategory();
            Comparable category2 = (Comparable)result2.getCategory();
            return category1.compareTo(category2);
        }
    }
}

