/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchIndexException;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchSuggestions;
import com.mathworks.search.lucene.HitCollectorSearchResult;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneSearchIndexException;
import com.mathworks.search.lucene.LuceneSearchVisitor;
import com.mathworks.search.lucene.MWAnalyzer;
import com.mathworks.search.lucene.MWMultiSearcher;
import com.mathworks.search.lucene.MWSearcher;
import com.mathworks.search.lucene.ScoreDocSearchResult;
import com.mathworks.search.lucene.SuggestionProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;

public class LuceneSearchEngine
implements SearchEngine {
    private final Analyzer fAnalyzer;
    private final SearchLanguage fLanguage;
    private final Collection<SearchField> fDefaultFields;
    private final IndexLocation[] fLocations;
    private MWSearcher fSearcher;

    public <T extends SearchField> LuceneSearchEngine(SearchLanguage language, Collection<T> defaultFields, IndexLocation ... locations) {
        this(language, new MWAnalyzer(language).getSearchAnalyzer(), defaultFields, locations);
    }

    public <T extends SearchField> LuceneSearchEngine(SearchLanguage language, Analyzer analyzer, Collection<T> defaultFields, IndexLocation ... locations) {
        this.fLanguage = language;
        this.fAnalyzer = analyzer;
        this.fDefaultFields = new LinkedList<T>(defaultFields);
        this.fLocations = new IndexLocation[locations.length];
        System.arraycopy(locations, 0, this.fLocations, 0, locations.length);
    }

    @Override
    public void openIndex() throws SearchIndexException {
        try {
            this.fSearcher = this.fLocations == null || this.fLocations.length == 0 ? null : (this.fLocations.length > 1 ? new MWMultiSearcher(this.fLocations) : this.fLocations[0].getSearcher());
        }
        catch (IOException ioe) {
            throw new LuceneSearchIndexException(ioe);
        }
    }

    private void openIfNecessary() throws IOException {
        if (this.fSearcher == null && this.fLocations != null && this.fLocations.length > 0) {
            this.openIndex();
        }
    }

    private IndexSearcher getIndexSearcher() throws IOException {
        this.openIfNecessary();
        return this.fSearcher != null ? this.fSearcher.getSearcher() : null;
    }

    private IndexReader getIndexReader() throws IOException {
        this.openIfNecessary();
        return this.fSearcher != null ? this.fSearcher.getReader() : null;
    }

    @Override
    public final void search(SearchCriteria criteria, SearchResultCollector ... collectors) throws SearchException {
        Query query = this.toLuceneQuery(criteria);
        try {
            IndexSearcher searcher = this.getIndexSearcher();
            int maxResults = criteria.getMaxResults();
            if (maxResults > 0) {
                this.searchMaxResults(searcher, query, maxResults, collectors);
            } else {
                this.searchAllResults(searcher, query, collectors);
            }
        }
        catch (IOException ioe) {
            throw new SearchException(ioe);
        }
        for (SearchResultCollector collector : collectors) {
            collector.resultsComplete();
        }
    }

    private void searchMaxResults(IndexSearcher searcher, Query query, int maxResults, SearchResultCollector ... collectors) throws IOException, SearchException {
        TopDocs hits = searcher.search(query, maxResults);
        ScoreDoc[] scoreHit = hits.scoreDocs;
        for (int i = 0; i < scoreHit.length; ++i) {
            ScoreDocSearchResult result = new ScoreDocSearchResult(searcher, scoreHit[i]);
            for (SearchResultCollector collector : collectors) {
                collector.examineResult(result);
            }
        }
    }

    private void searchAllResults(IndexSearcher searcher, Query query, SearchResultCollector ... collectors) throws IOException {
        CollectorAdapter hitCollector = new CollectorAdapter(searcher, collectors);
        searcher.search(query, (Collector)hitCollector);
    }

    @Override
    public final SearchSuggestions suggest(SearchField field, String partialText, int maxSuggestions) throws SearchException {
        if (field == null) {
            return SearchSuggestions.emptySuggestions();
        }
        try {
            IndexReader reader = this.getIndexReader();
            if (reader != null) {
                SuggestionProvider provider = new SuggestionProvider(reader, field);
                return provider.getSuggestions(partialText, maxSuggestions);
            }
            return SearchSuggestions.emptySuggestions();
        }
        catch (IOException ioe) {
            throw new SearchException(ioe);
        }
    }

    @Override
    public void closeIndex() throws IOException {
        if (this.fSearcher != null) {
            this.fSearcher.close();
        }
    }

    public Map<SearchResult, Explanation> explain(SearchCriteria criteria, int num) throws SearchException {
        LinkedHashMap<SearchResult, Explanation> explanations = new LinkedHashMap<SearchResult, Explanation>();
        Query query = this.toLuceneQuery(criteria);
        try {
            IndexSearcher searcher = this.getIndexSearcher();
            if (searcher != null) {
                ScoreDoc[] scoreHit;
                TopDocs hits = searcher.search(query, null, num);
                for (ScoreDoc aScoreHit : scoreHit = hits.scoreDocs) {
                    float score = aScoreHit.score;
                    int docId = aScoreHit.doc;
                    HitCollectorSearchResult result = new HitCollectorSearchResult(this.fSearcher.getSearcher(), docId, score);
                    explanations.put(result, searcher.explain(query, docId));
                }
                return explanations;
            }
            return null;
        }
        catch (IOException ioe) {
            throw new SearchException(ioe);
        }
    }

    private Query toLuceneQuery(SearchCriteria criteria) throws SearchException {
        LuceneSearchVisitor lsv = new LuceneSearchVisitor(this.fAnalyzer, this.fDefaultFields, this.fLanguage);
        criteria.getExpression().accept(lsv);
        return lsv.getBaseQuery();
    }

    private static class CollectorAdapter
    extends Collector {
        private int docBase;
        private final IndexSearcher iSearcher;
        private final SearchResultCollector[] iResultCollectors;
        private Scorer scorer;

        private CollectorAdapter(IndexSearcher searcher, SearchResultCollector ... resultCollector) {
            this.docBase = searcher.getIndexReader().getContext().docBaseInParent;
            this.iSearcher = searcher;
            this.iResultCollectors = resultCollector;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        public void collect(int i) {
            try {
                HitCollectorSearchResult result = new HitCollectorSearchResult(this.iSearcher, i + this.docBase, this.scorer.score());
                for (SearchResultCollector collector : this.iResultCollectors) {
                    collector.examineResult(result);
                }
            }
            catch (SearchException | IOException exception) {
                // empty catch block
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.docBase = context.docBase;
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

