/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchIndexException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.store.NoSuchDirectoryException;

class LuceneSearchIndexException
extends SearchIndexException {
    private static final Map<Class, SearchIndexException.Type> LUCENE_EXCEPTION_TYPES = new HashMap<Class, SearchIndexException.Type>();

    LuceneSearchIndexException(IOException cause) {
        super(LuceneSearchIndexException.getExceptionType(cause), (Throwable)cause);
    }

    private static SearchIndexException.Type getExceptionType(IOException cause) {
        if (LUCENE_EXCEPTION_TYPES.containsKey(cause.getClass())) {
            return LUCENE_EXCEPTION_TYPES.get(cause.getClass());
        }
        return SearchIndexException.Type.UNKNOWN_ERROR;
    }

    static {
        LUCENE_EXCEPTION_TYPES.put(IndexNotFoundException.class, SearchIndexException.Type.INDEX_NOT_FOUND);
        LUCENE_EXCEPTION_TYPES.put(NoSuchDirectoryException.class, SearchIndexException.Type.INDEX_NOT_FOUND);
        LUCENE_EXCEPTION_TYPES.put(IndexFormatTooOldException.class, SearchIndexException.Type.INDEX_INCOMPATIBLE);
        LUCENE_EXCEPTION_TYPES.put(IndexFormatTooNewException.class, SearchIndexException.Type.INDEX_INCOMPATIBLE);
    }
}

