/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchIndexException;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneSearchIndexException;
import com.mathworks.search.lucene.MWSearcher;
import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;

class MWIndexSearcher
extends IndexSearcher
implements MWSearcher {
    private final IndexLocation fLocation;

    MWIndexSearcher(IndexLocation location) throws SearchIndexException {
        super((IndexReader)MWIndexSearcher.getDirectoryReader(location));
        this.fLocation = location;
    }

    private static DirectoryReader getDirectoryReader(IndexLocation location) throws SearchIndexException {
        try {
            return DirectoryReader.open((Directory)location.getSearchDirectory());
        }
        catch (IOException ioe) {
            throw new LuceneSearchIndexException(ioe);
        }
    }

    @Override
    public IndexLocation getIndexForDocument(int docNum) {
        return this.fLocation;
    }

    @Override
    public IndexSearcher getSearcher() {
        return this;
    }

    @Override
    public IndexReader getReader() {
        return this.getIndexReader();
    }

    @Override
    public void close() throws IOException {
        this.getReader().close();
    }
}

