/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.csh;

import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.csh.CshFileBundle;
import com.mathworks.helpsearch.csh.CshIndexDocumentIterator;
import com.mathworks.helpsearch.csh.CshSearchField;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.SearchField;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;

public class MapFileIndexDocumentIterator
extends CshIndexDocumentIterator {
    public MapFileIndexDocumentIterator(File docRoot, DocProduct product, DocLanguage language) {
        super(docRoot, product, language);
    }

    @Override
    protected List<CshFileBundle> findCshFiles(File helpLocation) {
        LinkedList<CshFileBundle> mapFiles = new LinkedList<CshFileBundle>();
        this.inspectDirectory(helpLocation, mapFiles);
        return mapFiles;
    }

    private void inspectDirectory(File directory, List<CshFileBundle> mapFileList) {
        File[] mapFiles;
        File[] subDirectories;
        for (File subDirectory : subDirectories = directory.listFiles(new SubDirectoryFilter())) {
            this.inspectDirectory(subDirectory, mapFileList);
        }
        for (File mapFile : mapFiles = directory.listFiles(new MapFileFilter())) {
            mapFileList.add(new CshFileBundle(mapFile, this.getLanguage()));
        }
    }

    @Override
    protected IndexDocument<CshSearchField> createIndexDocument(File cshFile, String key, String value) {
        String relativeMapFilePath = this.getRelativePathToCshFile(cshFile);
        File parentFile = cshFile.getParentFile();
        File targetFile = parentFile == null ? new File(value) : new File(parentFile, value);
        String relativeTargetPath = this.getRelativePathToCshFile(targetFile);
        IndexDocument document = new IndexDocument();
        document.addFieldValue((SearchField)CshSearchField.MAP_FILE_PATH, relativeMapFilePath);
        document.addFieldValue((SearchField)CshSearchField.MAP_KEY, key);
        document.addFieldValue((SearchField)CshSearchField.CSH_TARGET, relativeTargetPath);
        return document;
    }

    private static class MapFileFilter
    implements FilenameFilter {
        private MapFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(".*(?<!_[a-z]{2}_[A-Z]{2}).map$");
        }
    }

    private static class SubDirectoryFilter
    implements FileFilter {
        private SubDirectoryFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

