/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.product.DocCenterItemResolver;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocLink {
    private static final Pattern INDEX_STRING_PATTERN = Pattern.compile("([^\\s]+)\\s([^\\s]+)\\s(.*)");
    private final Location fLocation;
    private final String fPath;
    private final String fLabel;

    public DocLink(Location location, String path, String label) {
        this.fLocation = location;
        this.fPath = path;
        this.fLabel = label;
    }

    public Location getLocation() {
        return this.fLocation;
    }

    public String getPath() {
        return this.fPath;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String toIndexString() {
        String label = this.fLabel.replaceAll("\\s", " ");
        return String.format("%s %s %s", this.fLocation.toString(), this.fPath, label);
    }

    public int hashCode() {
        return this.toIndexString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DocLink && ((DocLink)obj).toIndexString().equals(this.toIndexString());
    }

    public static List<DocLink> fromIndexString(DocumentationSet docSet, String indexString) {
        String[] parts = indexString.split("\n");
        ArrayList<DocLink> links = new ArrayList<DocLink>(parts.length);
        for (String part : parts) {
            DocLink link = DocLink.fromIndexStringLine(docSet, part);
            if (link == null) continue;
            links.add(link);
        }
        return links;
    }

    private static DocLink fromIndexStringLine(DocumentationSet docSet, String indexStringLine) {
        Matcher matcher = INDEX_STRING_PATTERN.matcher(indexStringLine);
        if (matcher.matches()) {
            String location = matcher.group(1);
            String path = matcher.group(2);
            String label = matcher.group(3);
            DocCenterItemResolver resolver = new DocCenterItemResolver(docSet);
            DocSetItem docSetItem = resolver.getDocSetItemByIndexString(location);
            if (docSetItem != null) {
                return new DocLink(Location.IN_PRODUCT, path, label);
            }
            try {
                Location locationValue = Location.valueOf(location);
                return new DocLink(locationValue, path, label);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public static enum Location {
        IN_PRODUCT,
        CROSS_PRODUCT,
        EXTERNAL;

    }
}

