/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.index.DocLink;
import com.mathworks.helpsearch.index.LinkResolver;
import com.mathworks.helpsearch.index.ProductLinkResolver;
import com.mathworks.helpsearch.index.example.Example;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DocumentationDocument {
    private static final Set<InformationType> REF_PAGE_TYPES = EnumSet.of(InformationType.FUNCTIONS, InformationType.BLOCKS);
    private final String fRelativePath;
    private final DocSetItem fDocSetItem;
    private String fTitle;
    private String fTitleTag;
    private String fBody;
    private String fPageSummary;
    private String fDescription;
    private InformationType fType;
    private List<String> fInfoTypeStrings;
    private List<ResultCategory> fBreadCrumbs;
    private final List<String> fSyntaxLines = new LinkedList<String>();
    private final Set<String> fOutgoingLinks = new HashSet<String>();
    private String fThumbnail;
    private int fPopularity = 0;
    private boolean fUnused = false;
    private boolean fMalformed = false;
    private final Set<ReferenceEntity> fRefEntities = new LinkedHashSet<ReferenceEntity>();
    private boolean fIgnoreForCategoryFacet = false;
    private final List<DocLink> fSeeAlsoLinks = new LinkedList<DocLink>();
    private final LinkResolver fResolver;
    private final List<String> fH1Lines = new LinkedList<String>();
    private final List<String> fH2Lines = new LinkedList<String>();
    private final Set<Example> fExamples = new LinkedHashSet<Example>();
    private final List<ReferenceData> fNestedRefData = new LinkedList<ReferenceData>();

    public static DocumentationDocument createDocumentationDocument(File docRoot, DocSetItem docSetItem, String relPath) {
        ProductLinkResolver resolver = new ProductLinkResolver(docRoot, docSetItem, relPath);
        return new DocumentationDocument(docSetItem, resolver, relPath);
    }

    public DocumentationDocument(DocSetItem docSetItem, LinkResolver resolver, String relPath) {
        this.fDocSetItem = docSetItem;
        this.fRelativePath = relPath;
        this.fResolver = resolver;
    }

    public DocSetItem getDocSetItem() {
        return this.fDocSetItem;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public String getTitleTag() {
        return this.fTitleTag;
    }

    public void setTitleTag(String titleTag) {
        this.fTitleTag = titleTag;
    }

    public String getBody() {
        return this.fBody;
    }

    public void setBody(String body) {
        this.fBody = body;
    }

    public String getPageSummary() {
        return this.fPageSummary;
    }

    public void setPageSummary(String refPageSummary) {
        this.fPageSummary = refPageSummary.replaceAll("\\s+", " ");
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String description) {
        this.fDescription = description == null ? "" : description;
    }

    public String getRelativePath() {
        return this.fRelativePath;
    }

    public InformationType getType() {
        return this.fType;
    }

    public void setType(InformationType type) {
        this.fType = type;
    }

    public List<String> getInfoTypeStrings() {
        if (this.fInfoTypeStrings == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.fInfoTypeStrings);
    }

    public void setInfoTypeStrings(List<String> infoTypes) {
        this.fInfoTypeStrings = new ArrayList<String>(infoTypes);
    }

    public List<ResultCategory> getBreadCrumbs() {
        if (this.fBreadCrumbs != null) {
            return Collections.unmodifiableList(this.fBreadCrumbs);
        }
        return Collections.emptyList();
    }

    public List<Example> getExamples() {
        return Collections.unmodifiableList(new ArrayList<Example>(this.fExamples));
    }

    public void setBreadCrumbs(List<ResultCategory> breadCrumbs) {
        this.fBreadCrumbs = new ArrayList<ResultCategory>(breadCrumbs);
    }

    public void setBreadCrumbs(ResultCategory ... breadCrumbs) {
        this.fBreadCrumbs = Arrays.asList(breadCrumbs);
    }

    public void addOutgoingLinks(List<String> outgoingLinks) {
        this.fOutgoingLinks.addAll(outgoingLinks);
    }

    public Collection<String> getOutgoingLinks() {
        return Collections.unmodifiableSet(this.fOutgoingLinks);
    }

    public void addSyntaxLines(Collection<String> syntaxLines) {
        this.fSyntaxLines.addAll(syntaxLines);
    }

    public List<String> getSyntaxLines() {
        return Collections.unmodifiableList(this.fSyntaxLines);
    }

    public void setThumbnail(String thumbnail) {
        this.fThumbnail = thumbnail;
    }

    public String getThumbnail() {
        return this.fThumbnail;
    }

    public void setPopularity(int popularity) {
        this.fPopularity = popularity;
    }

    public int getPopularity() {
        return this.fPopularity;
    }

    public void setUnused(boolean unused) {
        this.fUnused = unused;
    }

    public boolean isUnused() {
        return this.fUnused;
    }

    public void setBreadCrumbMalformed(boolean malformed) {
        this.fMalformed = malformed;
    }

    public boolean isBreadCrumbMalformed() {
        return this.fMalformed;
    }

    public boolean isReferencePage() {
        if (this.fInfoTypeStrings != null && !this.fInfoTypeStrings.isEmpty()) {
            for (String infoTypeStr : this.fInfoTypeStrings) {
                if (!infoTypeStr.contains("ref/")) continue;
                return true;
            }
        } else {
            return REF_PAGE_TYPES.contains(this.getType());
        }
        return false;
    }

    public void addReferenceEntities(Collection<ReferenceEntity> entities) {
        this.fRefEntities.addAll(entities);
    }

    public List<ReferenceEntity> getReferenceEntities() {
        return Collections.unmodifiableList(new ArrayList<ReferenceEntity>(this.fRefEntities));
    }

    public void setIgnoreForCategoryFacet(boolean ignore) {
        this.fIgnoreForCategoryFacet = ignore;
    }

    public boolean getIgnoreForCategoryFacet() {
        return this.fIgnoreForCategoryFacet;
    }

    public void addSeeAlsoLinks(List<DocLink> links) {
        this.fSeeAlsoLinks.addAll(links);
    }

    public List<DocLink> getSeeAlsoLinks() {
        return Collections.unmodifiableList(this.fSeeAlsoLinks);
    }

    public void addH1Lines(List<String> h1Lines) {
        this.fH1Lines.addAll(h1Lines);
    }

    public List<String> getH1Lines() {
        return Collections.unmodifiableList(this.fH1Lines);
    }

    public void addH2Lines(List<String> h2Lines) {
        this.fH2Lines.addAll(h2Lines);
    }

    public List<String> getH2Lines() {
        return Collections.unmodifiableList(this.fH2Lines);
    }

    public void addNestedReferenceData(List<ReferenceData> refData) {
        this.fNestedRefData.addAll(refData);
    }

    public List<ReferenceData> getNestedReferenceData() {
        return Collections.unmodifiableList(this.fNestedRefData);
    }

    public int hashCode() {
        return this.fDocSetItem.hashCode() + this.fRelativePath.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DocumentationDocument) {
            DocumentationDocument otherDoc = (DocumentationDocument)o;
            return otherDoc.fDocSetItem.equals(this.fDocSetItem) && otherDoc.fRelativePath.equals(this.fRelativePath);
        }
        return false;
    }

    public DocLink resolveRelativeLink(String linkTo, String label) {
        return this.fResolver.resolveLink(linkTo, label);
    }

    public void addExamples(Collection<Example> examples) {
        this.fExamples.addAll(examples);
    }
}

