/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.IndexDocumentIterator;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.Indexer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ProductIndexer {
    private final Indexer fIndexer;
    private final List<IndexDocumentIterator> fIndexDocumentIterables;

    public ProductIndexer(Indexer indexer, IndexDocumentIterator ... documentIterators) {
        this.fIndexer = indexer;
        this.fIndexDocumentIterables = Arrays.asList(documentIterators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index() throws IOException {
        this.fIndexer.openIndex();
        try {
            this.populateIndex();
        }
        finally {
            this.fIndexer.closeIndex();
        }
    }

    private void populateIndex() throws IOException {
        for (IndexDocumentIterator iterable : this.fIndexDocumentIterables) {
            this.handleIndexDocumentIterable(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIndexDocumentIterable(IndexDocumentIterator iterator) throws IOException {
        iterator.beforeIndex();
        try {
            while (iterator.hasNext()) {
                IndexDocument document = (IndexDocument)iterator.next();
                this.fIndexer.addDocument(document);
            }
        }
        finally {
            iterator.afterIndex();
        }
    }
}

