/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.index.XmlTagInfo;
import java.util.HashSet;
import java.util.Set;

public class DocCenterHtmlTagUtils {
    private static final Set<String> CONTENT_CONTAINTER_MARKERS = new HashSet<String>();
    private static final Set<String> WEB_DOC_CONTAINER_MARKERS;

    static boolean isContentContainerTag(XmlTagInfo tagInfo) {
        if (tagInfo.getTagName().equalsIgnoreCase("section")) {
            String id = tagInfo.getAttribute("id");
            return id != null && id.equals("doc_center_content");
        }
        if (tagInfo.getTagName().equalsIgnoreCase("div")) {
            String id = tagInfo.getAttribute("id");
            if (id != null && CONTENT_CONTAINTER_MARKERS.contains(id)) {
                return true;
            }
            String classes = tagInfo.getAttribute("class");
            if (classes != null) {
                String[] splitClasses;
                for (String splitClass : splitClasses = classes.split("\\s+")) {
                    if (!CONTENT_CONTAINTER_MARKERS.contains(splitClass) && !WEB_DOC_CONTAINER_MARKERS.contains(splitClass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static boolean isInContentContainer(XmlTagInfo tagInfo) {
        for (XmlTagInfo current = tagInfo; current != null; current = current.getParent()) {
            if (!DocCenterHtmlTagUtils.isContentContainerTag(current)) continue;
            return true;
        }
        return false;
    }

    static boolean isBreadCrumbContainerTag(XmlTagInfo xmlItem) {
        if (xmlItem.getTagName().equalsIgnoreCase("div")) {
            String htmlClass = xmlItem.getAttribute("class");
            if (htmlClass == null || htmlClass.trim().length() == 0) {
                htmlClass = xmlItem.getAttribute("id");
            }
            return htmlClass != null && htmlClass.equals("breadcrumbs");
        }
        return false;
    }

    static boolean isInBreadCrumb(XmlTagInfo xmlItem) {
        for (XmlTagInfo current = xmlItem; current != null; current = current.getParent()) {
            if (!DocCenterHtmlTagUtils.isBreadCrumbContainerTag(current)) continue;
            return true;
        }
        return false;
    }

    static {
        CONTENT_CONTAINTER_MARKERS.add("content_container2");
        CONTENT_CONTAINTER_MARKERS.add("content_container");
        CONTENT_CONTAINTER_MARKERS.add("expand_container");
        WEB_DOC_CONTAINER_MARKERS = new HashSet<String>();
        WEB_DOC_CONTAINER_MARKERS.add("doc_category_nav_foot");
        WEB_DOC_CONTAINER_MARKERS.add("doc_functionsgroup_container");
    }
}

