/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.index.DocumentTracker;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.IndexerObserver;
import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.index.report.HeaderReportPart;
import com.mathworks.helpsearch.index.report.ListReportPart;
import com.mathworks.helpsearch.index.report.SingleDocumentReport;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DocumentReportObserver
extends SingleDocumentReport
implements IndexerObserver<DocumentationSearchField> {
    private final String relativePath;
    private final Set<String> inboundLinks = new LinkedHashSet<String>();
    private boolean inTrackedDocument = false;

    public DocumentReportObserver(String relativePath) {
        this.relativePath = relativePath;
    }

    @Override
    public void indexingStarted() {
    }

    @Override
    public void startDocument(DocumentTracker<DocumentationSearchField> tracker) {
        if (tracker.getDocumentationDocument().getRelativePath().equals(this.relativePath)) {
            this.inTrackedDocument = true;
            this.addCompletedState(SingleDocumentReport.DocumentState.FOUND);
        }
    }

    @Override
    public void parsedDocument(DocumentTracker<DocumentationSearchField> tracker) {
        if (this.inTrackedDocument) {
            List<MicrodataItem> microdataItems = tracker.getTopLevelMicrodataItems();
            this.addMicrodataParts(microdataItems);
            DocumentationDocument documentationDocument = tracker.getDocumentationDocument();
            this.addDocumentationDocumentParts(documentationDocument);
        }
    }

    @Override
    public void createdIndexDocument(DocumentTracker<DocumentationSearchField> tracker) {
        if (this.inTrackedDocument) {
            List indexDocs = tracker.getIndexDocuments();
            this.addIndexDocumentParts(indexDocs);
        } else {
            DocumentationDocument doc = tracker.getDocumentationDocument();
            Collection<String> outgoing = doc.getOutgoingLinks();
            if (outgoing.contains(this.relativePath)) {
                this.inboundLinks.add(doc.getRelativePath());
            }
        }
    }

    @Override
    public void endDocument(DocumentTracker<DocumentationSearchField> tracker) {
        if (this.inTrackedDocument) {
            DocumentationDocument documentationDocument = tracker.getDocumentationDocument();
            Collection<String> outboundLinks = documentationDocument.getOutgoingLinks();
            this.addOutgoingLinksParts(outboundLinks);
            this.inTrackedDocument = false;
        }
    }

    @Override
    public void indexingFinished() {
        HeaderReportPart inboundHeader = new HeaderReportPart("Incoming links", 2);
        ListReportPart inboundLinksPart = ListReportPart.fromStrings(this.inboundLinks, ListReportPart.Direction.VERTICAL);
        this.addParts(inboundHeader, inboundLinksPart);
        this.addSummaryParts();
    }
}

