/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.product.DocAddOn;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HelpLocationRegistry {
    private final Map<String, DocSetItem> fItemsByPath = new HashMap<String, DocSetItem>();

    public HelpLocationRegistry(DocumentationSet docSet) {
        this(docSet.getAllProducts());
    }

    public HelpLocationRegistry(Collection<DocProduct> products) {
        for (DocProduct product : products) {
            this.addToHelpLocationMap(product);
            for (DocAddOn addOn : product.getDocAddOns()) {
                this.addToHelpLocationMap(addOn);
            }
        }
    }

    public DocSetItem getItemByHelpLocation(String helpLoc) {
        String normalized = HelpLocationRegistry.normalizeHelpLocation(helpLoc);
        return this.fItemsByPath.get(normalized);
    }

    private void addToHelpLocationMap(DocSetItem item) {
        Collection<List<String>> lookupPaths = item.getHelpLocation().getLookupPaths();
        for (List<String> path : lookupPaths) {
            String normalized = HelpLocationRegistry.normalizePath(path);
            this.fItemsByPath.put(normalized, item);
        }
    }

    private static String normalizeHelpLocation(String path) {
        String sepPattern = "[\\\\/]";
        String[] parts = path.replaceFirst("^" + sepPattern, "").split(sepPattern, -1);
        return HelpLocationRegistry.normalizePath(Arrays.asList(parts));
    }

    private static String normalizePath(List<String> parts) {
        if (parts == null || parts.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append('/').append(part);
        }
        return sb.substring(1);
    }
}

