/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.helpsearch.reference.ReferenceRetrievalStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ReferenceDataRetriever {
    private final ReferenceRetrievalStrategy fRetrievalStrategy;

    public ReferenceDataRetriever(ReferenceRetrievalStrategy retrievalStrategy) {
        this.fRetrievalStrategy = retrievalStrategy;
    }

    public List<ReferenceData> getReferenceData(ReferenceRequest request) {
        List<ReferenceData> results = this.fRetrievalStrategy.getReferenceData(request);
        Comparator<ReferenceData> comparator = request.getResultComparator();
        if (comparator != null) {
            results = new ArrayList<ReferenceData>(results);
            Collections.sort(results, comparator);
        }
        return Collections.unmodifiableList(results);
    }

    public void close() throws IOException {
        this.fRetrievalStrategy.close();
    }
}

