/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference.map;

import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.map.ReferenceEntityNode;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReferenceMapParser {
    private static final String DOCITEM_ELEMENT = "docitem";
    private static final String REF_ENTITY_ATTR = "refentityname";
    private static final String TYPE_ATTR = "type";
    private static final String SRC_PATTERN_ATTR = "src";
    private static final String SRC_ITEM_ELEMENT = "srcitem";
    private final File fRefMapFile;

    public ReferenceMapParser(File refMapFile) {
        this.fRefMapFile = refMapFile;
    }

    public void parse(ReferenceEntityNode entityTree) throws IOException, SAXException, ParserConfigurationException {
        Document doc = this.getRefMapDocument();
        NodeList docItemNodes = doc.getDocumentElement().getElementsByTagName(DOCITEM_ELEMENT);
        for (int i = 0; i < docItemNodes.getLength(); ++i) {
            this.parseDocItemNode(entityTree, docItemNodes.item(i));
        }
    }

    private void parseDocItemNode(ReferenceEntityNode entityTree, Node docItem) {
        String destString = docItem.getAttributes().getNamedItem(REF_ENTITY_ATTR).getTextContent();
        RefEntityType type = ReferenceMapParser.getEntityType(docItem);
        if (type != null) {
            NodeList srcItemNodes = ((Element)docItem).getElementsByTagName(SRC_ITEM_ELEMENT);
            for (int i = 0; i < srcItemNodes.getLength(); ++i) {
                String srcPattern = ReferenceMapParser.getSourcePattern(srcItemNodes.item(i));
                entityTree.add(srcPattern, destString, type);
            }
        }
    }

    private static RefEntityType getEntityType(Node docItem) {
        String destTypeString = docItem.getAttributes().getNamedItem(TYPE_ATTR).getTextContent();
        try {
            return RefEntityType.valueOf(destTypeString.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getSourcePattern(Node srcItem) {
        return srcItem.getAttributes().getNamedItem(SRC_PATTERN_ATTR).getTextContent();
    }

    private Document getRefMapDocument() throws ParserConfigurationException, IOException, SAXException {
        DOMParser domParser = new DOMParser();
        domParser.parse(this.getRefMapInputSource());
        return domParser.getDocument();
    }

    protected InputSource getRefMapInputSource() throws FileNotFoundException {
        return new InputSource(new FileInputStream(this.fRefMapFile));
    }
}

