/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.services.message.MWHandler;
import com.mathworks.services.message.MWMessage;

public final class MatlabLooper {
    private NativeMatlab fNativeMatlab = new NativeMatlab(true);
    private static NativeMatlab sNativeMatlab = new NativeMatlab(false);

    MatlabLooper() {
    }

    public static void postMatlabMessage(MWMessage mWMessage) {
        assert (NativeMatlab.nativeIsMatlabThread());
        sNativeMatlab.postMatlabMessage(mWMessage);
    }

    static Object sendMatlabMessage(MWMessage mWMessage) throws Exception {
        if (!NativeMatlab.nativeIsMatlabThread()) {
            throw new Exception("Must call this method from the MATLAB main thread");
        }
        return sNativeMatlab.sendMatlabMessage(mWMessage);
    }

    void postMatlabMessage(MWMessage mWMessage, MWHandler mWHandler) {
        if (!Matlab.isMatlabAvailable()) {
            RuntimeException runtimeException = new RuntimeException("This call can only be made when MATLAB is available.  Check with Matlab.isMatlabAvailable().");
            runtimeException.printStackTrace();
        }
        mWMessage.setHandler(mWHandler);
        try {
            this.fNativeMatlab.postMatlabMessage(mWMessage);
        }
        catch (Throwable throwable) {
            if (mWHandler != null) {
                MWMessage mWMessage2 = new MWMessage(-2);
                mWMessage2.addInteger("status", -1);
                mWHandler.messageReceived(mWMessage2);
            }
            throw new RuntimeException(throwable);
        }
    }

    void postMatlabRunnable(Runnable runnable, boolean bl) {
        this.fNativeMatlab.postMatlabRunnable(runnable, bl);
    }

    void postMatlabTimerRunnable(Runnable runnable) {
        this.fNativeMatlab.postMatlabTimerRunnable(runnable);
    }
}

